// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: EllipsoidSliceCommonPluginInfo.C
// ****************************************************************************

#include <EllipsoidSlicePluginInfo.h>
#include <EllipsoidSliceAttributes.h>

// ****************************************************************************
//  Method: EllipsoidSliceCommonPluginInfo::AllocAttributes
//
//  Purpose:
//    Return a pointer to a newly allocated attribute subject.
//
//  Returns:    A pointer to the newly allocated attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
EllipsoidSliceCommonPluginInfo::AllocAttributes()
{
    return new EllipsoidSliceAttributes;
}

// ****************************************************************************
//  Method: EllipsoidSliceCommonPluginInfo::CopyAttributes
//
//  Purpose:
//    Copy a EllipsoidSlice attribute subject.
//
//  Arguments:
//    to        The destination attribute subject.
//    from      The source attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
EllipsoidSliceCommonPluginInfo::CopyAttributes(AttributeSubject *to,
    AttributeSubject *from)
{
    *((EllipsoidSliceAttributes *) to) = *((EllipsoidSliceAttributes *) from);
}
