// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: ElevatePluginInfo.h
// ****************************************************************************

#ifndef ELEVATE_PLUGIN_INFO_H
#define ELEVATE_PLUGIN_INFO_H
#include <OperatorPluginInfo.h>
#include <operator_plugin_exports.h>

class ElevateAttributes;

// ****************************************************************************
//  Class: ElevatePluginInfo
//
//  Purpose:
//    Five classes that provide all the information about an Elevate operator
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
//  Modifications:
//
// ****************************************************************************

class ElevateGeneralPluginInfo : public virtual GeneralOperatorPluginInfo
{
  public:
    virtual const char *GetName() const;
    virtual const char *GetVersion() const;
    virtual const char *GetID() const;
    virtual bool  EnabledByDefault() const;
    virtual const char *GetCategoryName() const;
};

class ElevateCommonPluginInfo : public virtual CommonOperatorPluginInfo, public virtual ElevateGeneralPluginInfo
{
  public:
    virtual AttributeSubject *AllocAttributes();
    virtual void CopyAttributes(AttributeSubject *to, AttributeSubject *from);
};

class ElevateGUIPluginInfo : public virtual GUIOperatorPluginInfo, public virtual ElevateCommonPluginInfo
{
  public:
    virtual QString *GetMenuName() const;
    virtual QvisPostableWindowObserver *CreatePluginWindow(int type,
        AttributeSubject *attr, const QString &caption, const QString &shortName,
        QvisNotepadArea *notepad);
    virtual const char **XPMIconData() const;
};

class ElevateViewerEnginePluginInfo : public virtual ViewerEngineOperatorPluginInfo, public virtual ElevateCommonPluginInfo
{
  public:
    virtual AttributeSubject *GetClientAtts();
    virtual AttributeSubject *GetDefaultAtts();
    virtual void SetClientAtts(AttributeSubject *atts);
    virtual void GetClientAtts(AttributeSubject *atts);

    virtual void InitializeOperatorAtts(AttributeSubject *atts,
                                        const avtPlotMetaData &plot,
                                        const bool fromDefault);
    virtual void UpdateOperatorAtts(AttributeSubject *atts,
                                    const avtPlotMetaData &plot);
    virtual const char *GetMenuName() const;

    static void InitializeGlobalObjects();
  private:
    static ElevateAttributes *defaultAtts;
    static ElevateAttributes *clientAtts;
};

class ElevateViewerPluginInfo : public virtual ViewerOperatorPluginInfo, public virtual ElevateViewerEnginePluginInfo
{
  public:
    virtual const char **XPMIconData() const;
};

class ElevateEnginePluginInfo : public virtual EngineOperatorPluginInfo, public virtual ElevateViewerEnginePluginInfo
{
  public:
    virtual avtPluginFilter *AllocAvtPluginFilter();
};

class ElevateScriptingPluginInfo : public virtual ScriptingOperatorPluginInfo, public virtual ElevateCommonPluginInfo
{
  public:
    virtual void InitializePlugin(AttributeSubject *subj, void *data);
    virtual void *GetMethodTable(int *nMethods);
    virtual bool TypesMatch(void *pyobject);
    virtual char *GetLogString();
    virtual void SetDefaults(const AttributeSubject *atts);
};

#endif
