// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: ElevateCommonPluginInfo.C
// ****************************************************************************

#include <ElevatePluginInfo.h>
#include <ElevateAttributes.h>

// ****************************************************************************
//  Method: ElevateCommonPluginInfo::AllocAttributes
//
//  Purpose:
//    Return a pointer to a newly allocated attribute subject.
//
//  Returns:    A pointer to the newly allocated attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
ElevateCommonPluginInfo::AllocAttributes()
{
    return new ElevateAttributes;
}

// ****************************************************************************
//  Method: ElevateCommonPluginInfo::CopyAttributes
//
//  Purpose:
//    Copy a Elevate attribute subject.
//
//  Arguments:
//    to        The destination attribute subject.
//    from      The source attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
ElevateCommonPluginInfo::CopyAttributes(AttributeSubject *to,
    AttributeSubject *from)
{
    *((ElevateAttributes *) to) = *((ElevateAttributes *) from);
}
