// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  File: avtEdgeFilter.C
// ************************************************************************* //

#include <avtEdgeFilter.h>
#include <vtkExtractEdges.h>
#include <vtkGeometryFilter.h>

// ****************************************************************************
//  Method: avtEdgeFilter constructor
//
//  Programmer: js9 -- generated by xml2avt
//  Creation:   Mon Feb 23 16:33:23 PST 2009
//
// ****************************************************************************

avtEdgeFilter::avtEdgeFilter()
{
}


// ****************************************************************************
//  Method: avtEdgeFilter destructor
//
//  Programmer: js9 -- generated by xml2avt
//  Creation:   Mon Feb 23 16:33:23 PST 2009
//
//  Modifications:
//
// ****************************************************************************

avtEdgeFilter::~avtEdgeFilter()
{
}


// ****************************************************************************
//  Method:  avtEdgeFilter::Create
//
//  Programmer: js9 -- generated by xml2avt
//  Creation:   Mon Feb 23 16:33:23 PST 2009
//
// ****************************************************************************

avtFilter *
avtEdgeFilter::Create()
{
    return new avtEdgeFilter();
}


// ****************************************************************************
//  Method:      avtEdgeFilter::SetAtts
//
//  Purpose:
//      Sets the state of the filter based on the attribute object.
//
//  Arguments:
//      a        The attributes to use.
//
//  Programmer: js9 -- generated by xml2avt
//  Creation:   Mon Feb 23 16:33:23 PST 2009
//
// ****************************************************************************

void
avtEdgeFilter::SetAtts(const AttributeGroup *a)
{
    atts = *(const EdgeAttributes*)a;
}


// ****************************************************************************
//  Method: avtEdgeFilter::Equivalent
//
//  Purpose:
//      Returns true if creating a new avtEdgeFilter with the given
//      parameters would result in an equivalent avtEdgeFilter.
//
//  Programmer: js9 -- generated by xml2avt
//  Creation:   Mon Feb 23 16:33:23 PST 2009
//
// ****************************************************************************

bool
avtEdgeFilter::Equivalent(const AttributeGroup *a)
{
    return (atts == *(EdgeAttributes*)a);
}


// ****************************************************************************
//  Method: avtEdgeFilter::ExecuteData
//
//  Purpose:
//      Sends the specified input and output through the Edge filter.
//
//  Arguments:
//      inDR       The input data representation.
//
//  Returns:       The output data representation.
//
//  Programmer: Jeremy Meredith
//  Creation:   February 23, 2009
//
//  Modifications:
//   Eric Brugger, Thu Jul 24 09:29:05 PDT 2014
//   Modified the class to work with avtDataRepresentation.
//
// ****************************************************************************

avtDataRepresentation *
avtEdgeFilter::ExecuteData(avtDataRepresentation *inDR)
{
    //
    // Get the VTK data set.
    //
    vtkDataSet *inDS = inDR->GetDataVTK();

    vtkGeometryFilter *geom = NULL;
    vtkExtractEdges *ee = vtkExtractEdges::New();
    if (inDS->GetDataObjectType() != VTK_POLY_DATA)
    {
        geom = vtkGeometryFilter::New();
        geom->SetInputData(inDS);
        ee->SetInputConnection(geom->GetOutputPort());
    }
    else
    {
        ee->SetInputData(inDS);
    }
    ee->Update();

    vtkPolyData *outDS = ee->GetOutput();

    avtDataRepresentation *outDR = new avtDataRepresentation(outDS,
        inDR->GetDomain(), inDR->GetLabel());

    ee->Delete();
    if (geom)
        geom->Delete();

    return outDR;
}


// ****************************************************************************
//  Method:  avtEdgeFilter::UpdateDataObjectInfo
//
//  Purpose:
//    Set the topological dimension to 1.
//
//  Arguments:
//    none
//
//  Programmer:  Jeremy Meredith
//  Creation:    February 23, 2009
//
//  Modifications:
//    Jeremy Meredith, Fri Apr 30 13:46:43 EDT 2010
//    Disabled setting the topological dimension to 1.  Currently, mixing
//    e.g. a translucent pseudocolor-edge plot (i.e. topodim==1) with a normal
//    translucent pseudocolor plot results in lighting being disabled for both.
//
//    Brad Whitlock, Mon Apr  7 15:55:02 PDT 2014
//    Add filter metadata used in export.
//    Work partially supported by DOE Grant SC0007548.
//
// ****************************************************************************

void
avtEdgeFilter::UpdateDataObjectInfo(void)
{
    //if (GetInput()->GetInfo().GetAttributes().GetTopologicalDimension() != 0)
    //    GetOutput()->GetInfo().GetAttributes().SetTopologicalDimension(1);

    GetOutput()->GetInfo().GetAttributes().AddFilterMetaData("Edge");
}
