// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef QVISEDGEWINDOW_H
#define QVISEDGEWINDOW_H

#include <QvisOperatorWindow.h>
#include <AttributeSubject.h>

class EdgeAttributes;
class QCheckBox;

// ****************************************************************************
// Class: QvisEdgeWindow
//
// Purpose:
//    Defines QvisEdgeWindow class.
//
// Notes:      Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

class QvisEdgeWindow : public QvisOperatorWindow
{
    Q_OBJECT
  public:
    QvisEdgeWindow(const int type,
                         EdgeAttributes *subj,
                         const QString &caption = QString::null,
                         const QString &shortName = QString::null,
                         QvisNotepadArea *notepad = 0);
    virtual ~QvisEdgeWindow();
    virtual void CreateWindowContents();
  protected:
    void UpdateWindow(bool doAll);
    virtual void GetCurrentValues(int which_widget);
  private slots:
    void dummyChanged(bool val);
  private:
    QCheckBox *dummy;

    EdgeAttributes *atts;
};



#endif
