// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  EdgeScriptingPluginInfo.C
// ************************************************************************* //
#include <PyEdgeAttributes.h>
#include <EdgePluginInfo.h>

VISIT_OPERATOR_PLUGIN_ENTRY(Edge,Scripting)

// ****************************************************************************
// Method: EdgeScriptingPluginInfo::InitializePlugin
//
// Purpose:
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   data    : A pointer to data to be used by the observer function.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
EdgeScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    void *data)
{
    PyEdgeAttributes_StartUp((EdgeAttributes *)subj, data);
}

// ****************************************************************************
// Method: EdgeScriptingPluginInfo::GetMethodTable
//
// Purpose:
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void *
EdgeScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyEdgeAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: EdgeScriptingPluginInfo::TypesMatch
//
// Purpose:
//   Returns whether or not the input PyObject is Edge plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
EdgeScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyEdgeAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: EdgeScriptingPluginInfo::GetLogString
//
// Purpose:
//   Gets a string representation of the current attributes.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

char *
EdgeScriptingPluginInfo::GetLogString()
{
    std::string s(PyEdgeAttributes_GetLogString());
    char *v = new char[s.size() + 1];
    strcpy(v, s.c_str());
    return v;
}

// ****************************************************************************
// Method: EdgeScriptingPluginInfo::SetDefaults
//
// Purpose:
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
EdgeScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyEdgeAttributes_SetDefaults((const EdgeAttributes *)atts);
}
