// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: EdgePluginInfo.h
// ****************************************************************************

#ifndef EDGE_PLUGIN_INFO_H
#define EDGE_PLUGIN_INFO_H
#include <OperatorPluginInfo.h>
#include <operator_plugin_exports.h>

class EdgeAttributes;

// ****************************************************************************
//  Class: EdgePluginInfo
//
//  Purpose:
//    Five classes that provide all the information about an Edge operator
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
//  Modifications:
//
// ****************************************************************************

class EdgeGeneralPluginInfo : public virtual GeneralOperatorPluginInfo
{
  public:
    virtual const char *GetName() const;
    virtual const char *GetVersion() const;
    virtual const char *GetID() const;
    virtual bool  EnabledByDefault() const;
    virtual const char *GetCategoryName() const;
};

class EdgeCommonPluginInfo : public virtual CommonOperatorPluginInfo, public virtual EdgeGeneralPluginInfo
{
  public:
    virtual AttributeSubject *AllocAttributes();
    virtual void CopyAttributes(AttributeSubject *to, AttributeSubject *from);
};

class EdgeGUIPluginInfo : public virtual GUIOperatorPluginInfo, public virtual EdgeCommonPluginInfo
{
  public:
    virtual QString *GetMenuName() const;
    virtual QvisPostableWindowObserver *CreatePluginWindow(int type,
        AttributeSubject *attr, const QString &caption, const QString &shortName,
        QvisNotepadArea *notepad);
};

class EdgeViewerEnginePluginInfo : public virtual ViewerEngineOperatorPluginInfo, public virtual EdgeCommonPluginInfo
{
  public:
    virtual AttributeSubject *GetClientAtts();
    virtual AttributeSubject *GetDefaultAtts();
    virtual void SetClientAtts(AttributeSubject *atts);
    virtual void GetClientAtts(AttributeSubject *atts);

    virtual void InitializeOperatorAtts(AttributeSubject *atts,
                                        const avtPlotMetaData &plot,
                                        const bool fromDefault);
    virtual void UpdateOperatorAtts(AttributeSubject *atts,
                                    const avtPlotMetaData &plot);
    virtual const char *GetMenuName() const;

    static void InitializeGlobalObjects();
  private:
    static EdgeAttributes *defaultAtts;
    static EdgeAttributes *clientAtts;
};

class EdgeViewerPluginInfo : public virtual ViewerOperatorPluginInfo, public virtual EdgeViewerEnginePluginInfo
{
  public:
};

class EdgeEnginePluginInfo : public virtual EngineOperatorPluginInfo, public virtual EdgeViewerEnginePluginInfo
{
  public:
    virtual avtPluginFilter *AllocAvtPluginFilter();
};

class EdgeScriptingPluginInfo : public virtual ScriptingOperatorPluginInfo, public virtual EdgeCommonPluginInfo
{
  public:
    virtual void InitializePlugin(AttributeSubject *subj, void *data);
    virtual void *GetMethodTable(int *nMethods);
    virtual bool TypesMatch(void *pyobject);
    virtual char *GetLogString();
    virtual void SetDefaults(const AttributeSubject *atts);
};

#endif
