// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: EdgeGUIPluginInfo.C
// ****************************************************************************

#include <EdgePluginInfo.h>
#include <EdgeAttributes.h>
#include <QApplication>
#include <QvisEdgeWindow.h>

VISIT_OPERATOR_PLUGIN_ENTRY(Edge,GUI)

// ****************************************************************************
//  Method: EdgeGUIPluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the GUI menu.
//
//  Returns:    A pointer to the name to use in the GUI menu.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

QString *
EdgeGUIPluginInfo::GetMenuName() const
{
    return new QString(qApp->translate("OperatorNames", "Edge"));
}


// ****************************************************************************
//  Method: EdgeGUIPluginInfo::CreatePluginWindow
//
//  Purpose:
//    Return a pointer to an operator's attribute window.
//
//  Arguments:
//    type      The type of the operator.
//    attr      The attribute subject for the operator.
//    notepad   The notepad to use for posting the window.
//
//  Returns:    A pointer to the operator's attribute window.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

QvisPostableWindowObserver *
EdgeGUIPluginInfo::CreatePluginWindow(int type, AttributeSubject *attr,
    const QString &caption, const QString &shortName, QvisNotepadArea *notepad)
{
    return new QvisEdgeWindow(type, (EdgeAttributes *)attr,
        caption, shortName, notepad);
}

