// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: EdgeCommonPluginInfo.C
// ****************************************************************************

#include <EdgePluginInfo.h>
#include <EdgeAttributes.h>

// ****************************************************************************
//  Method: EdgeCommonPluginInfo::AllocAttributes
//
//  Purpose:
//    Return a pointer to a newly allocated attribute subject.
//
//  Returns:    A pointer to the newly allocated attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
EdgeCommonPluginInfo::AllocAttributes()
{
    return new EdgeAttributes;
}

// ****************************************************************************
//  Method: EdgeCommonPluginInfo::CopyAttributes
//
//  Purpose:
//    Copy a Edge attribute subject.
//
//  Arguments:
//    to        The destination attribute subject.
//    from      The source attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
EdgeCommonPluginInfo::CopyAttributes(AttributeSubject *to,
    AttributeSubject *from)
{
    *((EdgeAttributes *) to) = *((EdgeAttributes *) from);
}
