// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <EdgeAttributes.h>
#include <DataNode.h>

// ****************************************************************************
// Method: EdgeAttributes::EdgeAttributes
//
// Purpose:
//   Init utility for the EdgeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void EdgeAttributes::Init()
{
    dummy = true;

    EdgeAttributes::SelectAll();
}

// ****************************************************************************
// Method: EdgeAttributes::EdgeAttributes
//
// Purpose:
//   Copy utility for the EdgeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void EdgeAttributes::Copy(const EdgeAttributes &obj)
{
    dummy = obj.dummy;

    EdgeAttributes::SelectAll();
}

// Type map format string
const char *EdgeAttributes::TypeMapFormatString = EDGEATTRIBUTES_TMFS;
const AttributeGroup::private_tmfs_t EdgeAttributes::TmfsStruct = {EDGEATTRIBUTES_TMFS};


// ****************************************************************************
// Method: EdgeAttributes::EdgeAttributes
//
// Purpose:
//   Default constructor for the EdgeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

EdgeAttributes::EdgeAttributes() :
    AttributeSubject(EdgeAttributes::TypeMapFormatString)
{
    EdgeAttributes::Init();
}

// ****************************************************************************
// Method: EdgeAttributes::EdgeAttributes
//
// Purpose:
//   Constructor for the derived classes of EdgeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

EdgeAttributes::EdgeAttributes(private_tmfs_t tmfs) :
    AttributeSubject(tmfs.tmfs)
{
    EdgeAttributes::Init();
}

// ****************************************************************************
// Method: EdgeAttributes::EdgeAttributes
//
// Purpose:
//   Copy constructor for the EdgeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

EdgeAttributes::EdgeAttributes(const EdgeAttributes &obj) :
    AttributeSubject(EdgeAttributes::TypeMapFormatString)
{
    EdgeAttributes::Copy(obj);
}

// ****************************************************************************
// Method: EdgeAttributes::EdgeAttributes
//
// Purpose:
//   Copy constructor for derived classes of the EdgeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

EdgeAttributes::EdgeAttributes(const EdgeAttributes &obj, private_tmfs_t tmfs) :
    AttributeSubject(tmfs.tmfs)
{
    EdgeAttributes::Copy(obj);
}

// ****************************************************************************
// Method: EdgeAttributes::~EdgeAttributes
//
// Purpose:
//   Destructor for the EdgeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

EdgeAttributes::~EdgeAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: EdgeAttributes::operator =
//
// Purpose:
//   Assignment operator for the EdgeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

EdgeAttributes&
EdgeAttributes::operator = (const EdgeAttributes &obj)
{
    if (this == &obj) return *this;

    EdgeAttributes::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: EdgeAttributes::operator ==
//
// Purpose:
//   Comparison operator == for the EdgeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
EdgeAttributes::operator == (const EdgeAttributes &obj) const
{
    // Create the return value
    return ((dummy == obj.dummy));
}

// ****************************************************************************
// Method: EdgeAttributes::operator !=
//
// Purpose:
//   Comparison operator != for the EdgeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
EdgeAttributes::operator != (const EdgeAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: EdgeAttributes::TypeName
//
// Purpose:
//   Type name method for the EdgeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

const std::string
EdgeAttributes::TypeName() const
{
    return "EdgeAttributes";
}

// ****************************************************************************
// Method: EdgeAttributes::CopyAttributes
//
// Purpose:
//   CopyAttributes method for the EdgeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
EdgeAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const EdgeAttributes *tmp = (const EdgeAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: EdgeAttributes::CreateCompatible
//
// Purpose:
//   CreateCompatible method for the EdgeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeSubject *
EdgeAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new EdgeAttributes(*this);
    // Other cases could go here too.

    return retval;
}

// ****************************************************************************
// Method: EdgeAttributes::NewInstance
//
// Purpose:
//   NewInstance method for the EdgeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeSubject *
EdgeAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new EdgeAttributes(*this);
    else
        retval = new EdgeAttributes;

    return retval;
}

// ****************************************************************************
// Method: EdgeAttributes::SelectAll
//
// Purpose:
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
EdgeAttributes::SelectAll()
{
    Select(ID_dummy, (void *)&dummy);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: EdgeAttributes::CreateNode
//
// Purpose:
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
EdgeAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    EdgeAttributes defaultObject;
    bool addToParent = false;
    // Create a node for EdgeAttributes.
    DataNode *node = new DataNode("EdgeAttributes");

    if(completeSave || !FieldsEqual(ID_dummy, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("dummy", dummy));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: EdgeAttributes::SetFromNode
//
// Purpose:
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
EdgeAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("EdgeAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("dummy")) != 0)
        SetDummy(node->AsBool());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
EdgeAttributes::SetDummy(bool dummy_)
{
    dummy = dummy_;
    Select(ID_dummy, (void *)&dummy);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

bool
EdgeAttributes::GetDummy() const
{
    return dummy;
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: EdgeAttributes::GetFieldName
//
// Purpose:
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

std::string
EdgeAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_dummy: return "dummy";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: EdgeAttributes::GetFieldType
//
// Purpose:
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeGroup::FieldType
EdgeAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_dummy: return FieldType_bool;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: EdgeAttributes::GetFieldTypeName
//
// Purpose:
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

std::string
EdgeAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_dummy: return "bool";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: EdgeAttributes::FieldsEqual
//
// Purpose:
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
EdgeAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const EdgeAttributes &obj = *((const EdgeAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_dummy:
        {  // new scope
        retval = (dummy == obj.dummy);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

