// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: DualMeshPluginInfo.h
// ****************************************************************************

#ifndef DUALMESH_PLUGIN_INFO_H
#define DUALMESH_PLUGIN_INFO_H
#include <OperatorPluginInfo.h>
#include <operator_plugin_exports.h>

class DualMeshAttributes;

// ****************************************************************************
//  Class: DualMeshPluginInfo
//
//  Purpose:
//    Five classes that provide all the information about an DualMesh operator
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
//  Modifications:
//
// ****************************************************************************

class DualMeshGeneralPluginInfo : public virtual GeneralOperatorPluginInfo
{
  public:
    virtual const char *GetName() const;
    virtual const char *GetVersion() const;
    virtual const char *GetID() const;
    virtual bool  EnabledByDefault() const;
    virtual const char *GetCategoryName() const;
};

class DualMeshCommonPluginInfo : public virtual CommonOperatorPluginInfo, public virtual DualMeshGeneralPluginInfo
{
  public:
    virtual AttributeSubject *AllocAttributes();
    virtual void CopyAttributes(AttributeSubject *to, AttributeSubject *from);
};

class DualMeshGUIPluginInfo : public virtual GUIOperatorPluginInfo, public virtual DualMeshCommonPluginInfo
{
  public:
    virtual QString *GetMenuName() const;
    virtual QvisPostableWindowObserver *CreatePluginWindow(int type,
        AttributeSubject *attr, const QString &caption, const QString &shortName,
        QvisNotepadArea *notepad);
    virtual const char **XPMIconData() const;
};

class DualMeshViewerEnginePluginInfo : public virtual ViewerEngineOperatorPluginInfo, public virtual DualMeshCommonPluginInfo
{
  public:
    virtual AttributeSubject *GetClientAtts();
    virtual AttributeSubject *GetDefaultAtts();
    virtual void SetClientAtts(AttributeSubject *atts);
    virtual void GetClientAtts(AttributeSubject *atts);

    virtual void InitializeOperatorAtts(AttributeSubject *atts,
                                        const avtPlotMetaData &plot,
                                        const bool fromDefault);
    virtual void UpdateOperatorAtts(AttributeSubject *atts,
                                    const avtPlotMetaData &plot);
    virtual const char *GetMenuName() const;

    static void InitializeGlobalObjects();
  private:
    static DualMeshAttributes *defaultAtts;
    static DualMeshAttributes *clientAtts;
};

class DualMeshViewerPluginInfo : public virtual ViewerOperatorPluginInfo, public virtual DualMeshViewerEnginePluginInfo
{
  public:
    virtual const char **XPMIconData() const;
};

class DualMeshEnginePluginInfo : public virtual EngineOperatorPluginInfo, public virtual DualMeshViewerEnginePluginInfo
{
  public:
    virtual avtPluginFilter *AllocAvtPluginFilter();
};

class DualMeshScriptingPluginInfo : public virtual ScriptingOperatorPluginInfo, public virtual DualMeshCommonPluginInfo
{
  public:
    virtual void InitializePlugin(AttributeSubject *subj, void *data);
    virtual void *GetMethodTable(int *nMethods);
    virtual bool TypesMatch(void *pyobject);
    virtual char *GetLogString();
    virtual void SetDefaults(const AttributeSubject *atts);
};

#endif
