// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: DualMeshPluginInfo.C
// ****************************************************************************

#include <DualMeshPluginInfo.h>
#include <DualMeshAttributes.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(DualMesh,OP_EXPORT)

VISIT_OPERATOR_PLUGIN_ENTRY(DualMesh,General)

// ****************************************************************************
//  Method: DualMeshGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the operator plugin.
//
//  Returns:    A pointer to the name of the operator plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
DualMeshGeneralPluginInfo::GetName() const
{
    return "DualMesh";
}

// ****************************************************************************
//  Method: DualMeshGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the operator plugin.
//
//  Returns:    A pointer to the version of the operator plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
DualMeshGeneralPluginInfo::GetVersion() const
{
    return "1.0";
}

// ****************************************************************************
//  Method: DualMeshGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the operator plugin.
//
//  Returns:    A pointer to the id of the operator plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
DualMeshGeneralPluginInfo::GetID() const
{
    return "DualMesh_1.0";
}
// ****************************************************************************
//  Method: DualMeshGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
DualMeshGeneralPluginInfo::EnabledByDefault() const
{
    return true;
}

// ****************************************************************************
//  Method: DualMeshGeneralPluginInfo::GetCategoryName
//
//  Purpose:
//    Return the category name to which the operator belongs.
//
//  Returns:    Return the category name to which the operator belongs.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
DualMeshGeneralPluginInfo::GetCategoryName() const
{
    return "Geometry";
}
