// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: DualMeshGUIPluginInfo.C
// ****************************************************************************

#include <DualMeshPluginInfo.h>
#include <DualMeshAttributes.h>
#include <QApplication>
#include <QvisDualMeshWindow.h>

VISIT_OPERATOR_PLUGIN_ENTRY(DualMesh,GUI)

// ****************************************************************************
//  Method: DualMeshGUIPluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the GUI menu.
//
//  Returns:    A pointer to the name to use in the GUI menu.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

QString *
DualMeshGUIPluginInfo::GetMenuName() const
{
    return new QString(qApp->translate("OperatorNames", "Dual Mesh"));
}


// ****************************************************************************
//  Method: DualMeshGUIPluginInfo::CreatePluginWindow
//
//  Purpose:
//    Return a pointer to an operator's attribute window.
//
//  Arguments:
//    type      The type of the operator.
//    attr      The attribute subject for the operator.
//    notepad   The notepad to use for posting the window.
//
//  Returns:    A pointer to the operator's attribute window.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

QvisPostableWindowObserver *
DualMeshGUIPluginInfo::CreatePluginWindow(int type, AttributeSubject *attr,
    const QString &caption, const QString &shortName, QvisNotepadArea *notepad)
{
    return new QvisDualMeshWindow(type, (DualMeshAttributes *)attr,
        caption, shortName, notepad);
}

// ****************************************************************************
//  Method: DualMeshGUIPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

#include <DualMesh.xpm>
const char **
DualMeshGUIPluginInfo::XPMIconData() const
{
    return DualMesh_xpm;
}

