// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: DualMeshCommonPluginInfo.C
// ****************************************************************************

#include <DualMeshPluginInfo.h>
#include <DualMeshAttributes.h>

// ****************************************************************************
//  Method: DualMeshCommonPluginInfo::AllocAttributes
//
//  Purpose:
//    Return a pointer to a newly allocated attribute subject.
//
//  Returns:    A pointer to the newly allocated attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
DualMeshCommonPluginInfo::AllocAttributes()
{
    return new DualMeshAttributes;
}

// ****************************************************************************
//  Method: DualMeshCommonPluginInfo::CopyAttributes
//
//  Purpose:
//    Copy a DualMesh attribute subject.
//
//  Arguments:
//    to        The destination attribute subject.
//    from      The source attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
DualMeshCommonPluginInfo::CopyAttributes(AttributeSubject *to,
    AttributeSubject *from)
{
    *((DualMeshAttributes *) to) = *((DualMeshAttributes *) from);
}
