// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  File: avtDisplacePluginFilter.h
// ************************************************************************* //

#ifndef AVT_DisplacePlugin_FILTER_H
#define AVT_DisplacePlugin_FILTER_H


#include <avtPluginFilter.h>
#include <avtSingleFilterFacade.h>

#include <DisplaceAttributes.h>

class     avtDisplaceFilter;

// ****************************************************************************
//  Class: avtDisplacePluginFilter
//
//  Purpose:
//      A plugin operator for Displace.
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   May 18, 2007
//
//  Modifications:
//
//    Tom Fogal, Tue Jun 23 20:44:11 MDT 2009
//    Added const version of GetFacaded filter.
//
// ****************************************************************************

class avtDisplacePluginFilter : virtual public avtPluginFilter,
                                virtual public avtSingleFilterFacade
{
  public:
                         avtDisplacePluginFilter();
    virtual             ~avtDisplacePluginFilter();

    static avtFilter    *Create();

    virtual const char  *GetType(void)  { return "avtDisplacePluginFilter"; };
    virtual const char  *GetDescription(void)
                             { return "Displace"; };

    virtual void         SetAtts(const AttributeGroup*);
    virtual bool         Equivalent(const AttributeGroup*);

  protected:
    avtDisplaceFilter         *displacer;
    DisplaceAttributes         atts;

    virtual avtFilter         *GetFacadedFilter();
    virtual const avtFilter   *GetFacadedFilter() const;

    static void UpdateDataObjectInfoCB(avtDataObject_p &input,
                                       avtDataObject_p &output, void *);
};

#endif
