// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include "QvisDisplaceWindow.h"

#include <DisplaceAttributes.h>

#include <QLabel>
#include <QLayout>
#include <QLineEdit>
#include <QvisVariableButton.h>


// ****************************************************************************
// Method: QvisDisplaceWindow::QvisDisplaceWindow
//
// Purpose: 
//   Constructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisDisplaceWindow::QvisDisplaceWindow(const int type,
                         DisplaceAttributes *subj,
                         const QString &caption,
                         const QString &shortName,
                         QvisNotepadArea *notepad)
    : QvisOperatorWindow(type,subj, caption, shortName, notepad)
{
    atts = subj;
}


// ****************************************************************************
// Method: QvisDisplaceWindow::~QvisDisplaceWindow
//
// Purpose: 
//   Destructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisDisplaceWindow::~QvisDisplaceWindow()
{
}


// ****************************************************************************
// Method: QvisDisplaceWindow::CreateWindowContents
//
// Purpose: 
//   Creates the widgets for the window.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   Cyrus Harrison, on Aug 18 20:13:20 PDT 2008
//   Qt4 Port - Autogen + Changed label for variable button.   
//
// ****************************************************************************

void
QvisDisplaceWindow::CreateWindowContents()
{
    QGridLayout *mainLayout = new QGridLayout(0);
    topLayout->addLayout(mainLayout);

    factorLabel = new QLabel(tr("Displacement multiplier "), central);
    mainLayout->addWidget(factorLabel,0,0);
    factor = new QLineEdit(central);
    connect(factor, SIGNAL(returnPressed()),
            this, SLOT(factorProcessText()));
    mainLayout->addWidget(factor, 0,1);

    variableLabel = new QLabel(tr("Displacement variable"), central);
    mainLayout->addWidget(variableLabel,1,0);
    int variableMask = QvisVariableButton::Vectors;
    variable = new QvisVariableButton(true, true, true, variableMask, central);
    variable->setDefaultVariable("default");
    connect(variable, SIGNAL(activated(const QString&)),
            this, SLOT(variableChanged(const QString&)));
    mainLayout->addWidget(variable, 1,1);

}


// ****************************************************************************
// Method: QvisDisplaceWindow::UpdateWindow
//
// Purpose: 
//   Updates the widgets in the window when the subject changes.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisDisplaceWindow::UpdateWindow(bool doAll)
{

    for(int i = 0; i < atts->NumAttributes(); ++i)
    {
        if(!doAll)
        {
            if(!atts->IsSelected(i))
            {
                continue;
            }
        }

        switch(i)
        {
          case DisplaceAttributes::ID_factor:
            factor->setText(DoubleToQString(atts->GetFactor()));
            break;
          case DisplaceAttributes::ID_variable:
            variable->blockSignals(true);
            variable->setText(QString(atts->GetVariable().c_str()));
            variable->blockSignals(false);
            break;
        }
    }
}


// ****************************************************************************
// Method: QvisDisplaceWindow::GetCurrentValues
//
// Purpose: 
//   Gets values from certain widgets and stores them in the subject.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisDisplaceWindow::GetCurrentValues(int which_widget)
{
    bool doAll = (which_widget == -1);

    // Do factor
    if(which_widget == DisplaceAttributes::ID_factor || doAll)
    {
        double val;
        if(LineEditGetDouble(factor, val))
            atts->SetFactor(val);
        else
        {
            ResettingError(tr("Displacement multiplier "),
                DoubleToQString(atts->GetFactor()));
            atts->SetFactor(atts->GetFactor());
        }
    }

}


//
// Qt Slot functions
//


void
QvisDisplaceWindow::factorProcessText()
{
    GetCurrentValues(DisplaceAttributes::ID_factor);
    Apply();
}


void
QvisDisplaceWindow::variableChanged(const QString &varName)
{
    atts->SetVariable(varName.toStdString());
    SetUpdate(false);
    Apply();
}


