// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  DisplaceScriptingPluginInfo.C
// ************************************************************************* //
#include <PyDisplaceAttributes.h>
#include <DisplacePluginInfo.h>

VISIT_OPERATOR_PLUGIN_ENTRY(Displace,Scripting)

// ****************************************************************************
// Method: DisplaceScriptingPluginInfo::InitializePlugin
//
// Purpose:
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   data    : A pointer to data to be used by the observer function.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
DisplaceScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    void *data)
{
    PyDisplaceAttributes_StartUp((DisplaceAttributes *)subj, data);
}

// ****************************************************************************
// Method: DisplaceScriptingPluginInfo::GetMethodTable
//
// Purpose:
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void *
DisplaceScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyDisplaceAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: DisplaceScriptingPluginInfo::TypesMatch
//
// Purpose:
//   Returns whether or not the input PyObject is Displace plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
DisplaceScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyDisplaceAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: DisplaceScriptingPluginInfo::GetLogString
//
// Purpose:
//   Gets a string representation of the current attributes.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

char *
DisplaceScriptingPluginInfo::GetLogString()
{
    std::string s(PyDisplaceAttributes_GetLogString());
    char *v = new char[s.size() + 1];
    strcpy(v, s.c_str());
    return v;
}

// ****************************************************************************
// Method: DisplaceScriptingPluginInfo::SetDefaults
//
// Purpose:
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
DisplaceScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyDisplaceAttributes_SetDefaults((const DisplaceAttributes *)atts);
}
