// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <DisplaceAttributes.h>
#include <DataNode.h>

// ****************************************************************************
// Method: DisplaceAttributes::DisplaceAttributes
//
// Purpose:
//   Init utility for the DisplaceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void DisplaceAttributes::Init()
{
    factor = 1;

    DisplaceAttributes::SelectAll();
}

// ****************************************************************************
// Method: DisplaceAttributes::DisplaceAttributes
//
// Purpose:
//   Copy utility for the DisplaceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void DisplaceAttributes::Copy(const DisplaceAttributes &obj)
{
    factor = obj.factor;
    variable = obj.variable;

    DisplaceAttributes::SelectAll();
}

// Type map format string
const char *DisplaceAttributes::TypeMapFormatString = DISPLACEATTRIBUTES_TMFS;
const AttributeGroup::private_tmfs_t DisplaceAttributes::TmfsStruct = {DISPLACEATTRIBUTES_TMFS};


// ****************************************************************************
// Method: DisplaceAttributes::DisplaceAttributes
//
// Purpose:
//   Default constructor for the DisplaceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

DisplaceAttributes::DisplaceAttributes() :
    AttributeSubject(DisplaceAttributes::TypeMapFormatString),
    variable("default")
{
    DisplaceAttributes::Init();
}

// ****************************************************************************
// Method: DisplaceAttributes::DisplaceAttributes
//
// Purpose:
//   Constructor for the derived classes of DisplaceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

DisplaceAttributes::DisplaceAttributes(private_tmfs_t tmfs) :
    AttributeSubject(tmfs.tmfs),
    variable("default")
{
    DisplaceAttributes::Init();
}

// ****************************************************************************
// Method: DisplaceAttributes::DisplaceAttributes
//
// Purpose:
//   Copy constructor for the DisplaceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

DisplaceAttributes::DisplaceAttributes(const DisplaceAttributes &obj) :
    AttributeSubject(DisplaceAttributes::TypeMapFormatString)
{
    DisplaceAttributes::Copy(obj);
}

// ****************************************************************************
// Method: DisplaceAttributes::DisplaceAttributes
//
// Purpose:
//   Copy constructor for derived classes of the DisplaceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

DisplaceAttributes::DisplaceAttributes(const DisplaceAttributes &obj, private_tmfs_t tmfs) :
    AttributeSubject(tmfs.tmfs)
{
    DisplaceAttributes::Copy(obj);
}

// ****************************************************************************
// Method: DisplaceAttributes::~DisplaceAttributes
//
// Purpose:
//   Destructor for the DisplaceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

DisplaceAttributes::~DisplaceAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: DisplaceAttributes::operator =
//
// Purpose:
//   Assignment operator for the DisplaceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

DisplaceAttributes&
DisplaceAttributes::operator = (const DisplaceAttributes &obj)
{
    if (this == &obj) return *this;

    DisplaceAttributes::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: DisplaceAttributes::operator ==
//
// Purpose:
//   Comparison operator == for the DisplaceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
DisplaceAttributes::operator == (const DisplaceAttributes &obj) const
{
    // Create the return value
    return ((factor == obj.factor) &&
            (variable == obj.variable));
}

// ****************************************************************************
// Method: DisplaceAttributes::operator !=
//
// Purpose:
//   Comparison operator != for the DisplaceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
DisplaceAttributes::operator != (const DisplaceAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: DisplaceAttributes::TypeName
//
// Purpose:
//   Type name method for the DisplaceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

const std::string
DisplaceAttributes::TypeName() const
{
    return "DisplaceAttributes";
}

// ****************************************************************************
// Method: DisplaceAttributes::CopyAttributes
//
// Purpose:
//   CopyAttributes method for the DisplaceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
DisplaceAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const DisplaceAttributes *tmp = (const DisplaceAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: DisplaceAttributes::CreateCompatible
//
// Purpose:
//   CreateCompatible method for the DisplaceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeSubject *
DisplaceAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new DisplaceAttributes(*this);
    // Other cases could go here too.

    return retval;
}

// ****************************************************************************
// Method: DisplaceAttributes::NewInstance
//
// Purpose:
//   NewInstance method for the DisplaceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeSubject *
DisplaceAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new DisplaceAttributes(*this);
    else
        retval = new DisplaceAttributes;

    return retval;
}

// ****************************************************************************
// Method: DisplaceAttributes::SelectAll
//
// Purpose:
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
DisplaceAttributes::SelectAll()
{
    Select(ID_factor,   (void *)&factor);
    Select(ID_variable, (void *)&variable);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: DisplaceAttributes::CreateNode
//
// Purpose:
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
DisplaceAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    DisplaceAttributes defaultObject;
    bool addToParent = false;
    // Create a node for DisplaceAttributes.
    DataNode *node = new DataNode("DisplaceAttributes");

    if(completeSave || !FieldsEqual(ID_factor, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("factor", factor));
    }

    if(completeSave || !FieldsEqual(ID_variable, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("variable", variable));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: DisplaceAttributes::SetFromNode
//
// Purpose:
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
DisplaceAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("DisplaceAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("factor")) != 0)
        SetFactor(node->AsDouble());
    if((node = searchNode->GetNode("variable")) != 0)
        SetVariable(node->AsString());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
DisplaceAttributes::SetFactor(double factor_)
{
    factor = factor_;
    Select(ID_factor, (void *)&factor);
}

void
DisplaceAttributes::SetVariable(const std::string &variable_)
{
    variable = variable_;
    Select(ID_variable, (void *)&variable);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

double
DisplaceAttributes::GetFactor() const
{
    return factor;
}

const std::string &
DisplaceAttributes::GetVariable() const
{
    return variable;
}

std::string &
DisplaceAttributes::GetVariable()
{
    return variable;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
DisplaceAttributes::SelectVariable()
{
    Select(ID_variable, (void *)&variable);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: DisplaceAttributes::GetFieldName
//
// Purpose:
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

std::string
DisplaceAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_factor:   return "factor";
    case ID_variable: return "variable";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: DisplaceAttributes::GetFieldType
//
// Purpose:
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeGroup::FieldType
DisplaceAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_factor:   return FieldType_double;
    case ID_variable: return FieldType_variablename;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: DisplaceAttributes::GetFieldTypeName
//
// Purpose:
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

std::string
DisplaceAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_factor:   return "double";
    case ID_variable: return "variablename";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: DisplaceAttributes::FieldsEqual
//
// Purpose:
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
DisplaceAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const DisplaceAttributes &obj = *((const DisplaceAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_factor:
        {  // new scope
        retval = (factor == obj.factor);
        }
        break;
    case ID_variable:
        {  // new scope
        retval = (variable == obj.variable);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

