// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  DelaunayScriptingPluginInfo.C
// ************************************************************************* //
#include <PyDelaunayAttributes.h>
#include <DelaunayPluginInfo.h>

VISIT_OPERATOR_PLUGIN_ENTRY(Delaunay,Scripting)

// ****************************************************************************
// Method: DelaunayScriptingPluginInfo::InitializePlugin
//
// Purpose:
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   data    : A pointer to data to be used by the observer function.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
DelaunayScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    void *data)
{
    PyDelaunayAttributes_StartUp((DelaunayAttributes *)subj, data);
}

// ****************************************************************************
// Method: DelaunayScriptingPluginInfo::GetMethodTable
//
// Purpose:
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void *
DelaunayScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyDelaunayAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: DelaunayScriptingPluginInfo::TypesMatch
//
// Purpose:
//   Returns whether or not the input PyObject is Delaunay plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
DelaunayScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyDelaunayAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: DelaunayScriptingPluginInfo::GetLogString
//
// Purpose:
//   Gets a string representation of the current attributes.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

char *
DelaunayScriptingPluginInfo::GetLogString()
{
    std::string s(PyDelaunayAttributes_GetLogString());
    char *v = new char[s.size() + 1];
    strcpy(v, s.c_str());
    return v;
}

// ****************************************************************************
// Method: DelaunayScriptingPluginInfo::SetDefaults
//
// Purpose:
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
DelaunayScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyDelaunayAttributes_SetDefaults((const DelaunayAttributes *)atts);
}
