// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: DelaunayCommonPluginInfo.C
// ****************************************************************************

#include <DelaunayPluginInfo.h>
#include <DelaunayAttributes.h>

// ****************************************************************************
//  Method: DelaunayCommonPluginInfo::AllocAttributes
//
//  Purpose:
//    Return a pointer to a newly allocated attribute subject.
//
//  Returns:    A pointer to the newly allocated attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
DelaunayCommonPluginInfo::AllocAttributes()
{
    return new DelaunayAttributes;
}

// ****************************************************************************
//  Method: DelaunayCommonPluginInfo::CopyAttributes
//
//  Purpose:
//    Copy a Delaunay attribute subject.
//
//  Arguments:
//    to        The destination attribute subject.
//    from      The source attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
DelaunayCommonPluginInfo::CopyAttributes(AttributeSubject *to,
    AttributeSubject *from)
{
    *((DelaunayAttributes *) to) = *((DelaunayAttributes *) from);
}
