// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

package llnl.visit.operators;

import llnl.visit.AttributeSubject;
import llnl.visit.CommunicationBuffer;
import llnl.visit.Plugin;

// ****************************************************************************
// Class: DelaunayAttributes
//
// Purpose:
//    Attributes for the Delaunay Operator
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

public class DelaunayAttributes extends AttributeSubject implements Plugin
{
    private static int DelaunayAttributes_numAdditionalAtts = 1;

    // Enum values
    public final static int DIMENSION_AUTOMATIC = 0;
    public final static int DIMENSION_TRIANGULATION = 1;
    public final static int DIMENSION_TETRAHEDRALIZATION = 2;


    public DelaunayAttributes()
    {
        super(DelaunayAttributes_numAdditionalAtts);

        dimension = DIMENSION_AUTOMATIC;
    }

    public DelaunayAttributes(int nMoreFields)
    {
        super(DelaunayAttributes_numAdditionalAtts + nMoreFields);

        dimension = DIMENSION_AUTOMATIC;
    }

    public DelaunayAttributes(DelaunayAttributes obj)
    {
        super(obj);

        dimension = obj.dimension;

        SelectAll();
    }

    public int Offset()
    {
        return super.Offset() + super.GetNumAdditionalAttributes();
    }

    public int GetNumAdditionalAttributes()
    {
        return DelaunayAttributes_numAdditionalAtts;
    }

    public boolean equals(DelaunayAttributes obj)
    {
        // Create the return value
        return ((dimension == obj.dimension));
    }

    public String GetName() { return "Delaunay"; }
    public String GetVersion() { return "1.0"; }

    // Property setting methods
    public void SetDimension(int dimension_)
    {
        dimension = dimension_;
        Select(0);
    }

    // Property getting methods
    public int GetDimension() { return dimension; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        if(WriteSelect(0, buf))
            buf.WriteInt(dimension);
    }

    public void ReadAtts(int index, CommunicationBuffer buf)
    {
        SetDimension(buf.ReadInt());
    }

    public String toString(String indent)
    {
        String str = new String();
        str = str + indent + "dimension = ";
        if(dimension == DIMENSION_AUTOMATIC)
            str = str + "DIMENSION_AUTOMATIC";
        if(dimension == DIMENSION_TRIANGULATION)
            str = str + "DIMENSION_TRIANGULATION";
        if(dimension == DIMENSION_TETRAHEDRALIZATION)
            str = str + "DIMENSION_TETRAHEDRALIZATION";
        str = str + "\n";
        return str;
    }


    // Attributes
    private int dimension;
}

