// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  File: avtDeferExpressionFilter.C
// ************************************************************************* //

#include <avtDeferExpressionFilter.h>

#include <ExpressionList.h>
#include <ParsingExprList.h>

#include <avtExpressionEvaluatorFilter.h>

#include <InvalidVariableException.h>


// ****************************************************************************
//  Method: avtDeferExpressionFilter constructor
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   Thu Sep 1 06:35:41 PDT 2005
//
// ****************************************************************************

avtDeferExpressionFilter::avtDeferExpressionFilter()
{
}


// ****************************************************************************
//  Method: avtDeferExpressionFilter destructor
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   Thu Sep 1 06:35:41 PDT 2005
//
//  Modifications:
//
// ****************************************************************************

avtDeferExpressionFilter::~avtDeferExpressionFilter()
{
}


// ****************************************************************************
//  Method:  avtDeferExpressionFilter::Create
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   Thu Sep 1 06:35:41 PDT 2005
//
// ****************************************************************************

avtFilter *
avtDeferExpressionFilter::Create()
{
    return new avtDeferExpressionFilter();
}


// ****************************************************************************
//  Method:      avtDeferExpressionFilter::SetAtts
//
//  Purpose:
//      Sets the state of the filter based on the attribute object.
//
//  Arguments:
//      a        The attributes to use.
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   Thu Sep 1 06:35:41 PDT 2005
//
// ****************************************************************************

void
avtDeferExpressionFilter::SetAtts(const AttributeGroup *a)
{
    atts = *(const DeferExpressionAttributes*)a;
}


// ****************************************************************************
//  Method: avtDeferExpressionFilter::Equivalent
//
//  Purpose:
//      Returns true if creating a new avtDeferExpressionFilter with the given
//      parameters would result in an equivalent avtDeferExpressionFilter.
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   Thu Sep 1 06:35:41 PDT 2005
//
// ****************************************************************************

bool
avtDeferExpressionFilter::Equivalent(const AttributeGroup *a)
{
    return (atts == *(DeferExpressionAttributes*)a);
}


// ****************************************************************************
//  Method: avtDeferExpressionFilter::GetVariablesToEvaluate
//
//  Purpose:
//      Gets the list of variables to be evaluated with this filter's 
//      execution.
//
//  Programmer: Hank Childs
//  Creation:   September 23, 2010
//
// ****************************************************************************

void
avtDeferExpressionFilter::GetVariablesToEvaluate(std::vector<std::string> &vars)
{
    vars = atts.GetExprs();
}


