// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <PyDeferExpressionAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>

// ****************************************************************************
// Module: PyDeferExpressionAttributes
//
// Purpose:
//   Attributes for the DeferExpression operator
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a DeferExpressionAttributes.
//
struct DeferExpressionAttributesObject
{
    PyObject_HEAD
    DeferExpressionAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewDeferExpressionAttributes(int);

std::string
PyDeferExpressionAttributes_ToString(const DeferExpressionAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    {   const stringVector &exprs = atts->GetExprs();
        snprintf(tmpStr, 1000, "%sexprs = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < exprs.size(); ++i)
        {
            snprintf(tmpStr, 1000, "\"%s\"", exprs[i].c_str());
            str += tmpStr;
            if(i < exprs.size() - 1)
            {
                snprintf(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        snprintf(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    return str;
}

static PyObject *
DeferExpressionAttributes_Notify(PyObject *self, PyObject *args)
{
    DeferExpressionAttributesObject *obj = (DeferExpressionAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
DeferExpressionAttributes_SetExprs(PyObject *self, PyObject *args)
{
    DeferExpressionAttributesObject *obj = (DeferExpressionAttributesObject *)self;

    stringVector  &vec = obj->data->GetExprs();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyString_Check(item))
                vec[i] = std::string(PyString_AS_STRING(item));
            else
                vec[i] = std::string("");
        }
    }
    else if(PyString_Check(tuple))
    {
        vec.resize(1);
        vec[0] = std::string(PyString_AS_STRING(tuple));
    }
    else
        return NULL;

    // Mark the exprs in the object as modified.
    obj->data->SelectExprs();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
DeferExpressionAttributes_GetExprs(PyObject *self, PyObject *args)
{
    DeferExpressionAttributesObject *obj = (DeferExpressionAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the exprs.
    const stringVector &exprs = obj->data->GetExprs();
    PyObject *retval = PyTuple_New(exprs.size());
    for(size_t i = 0; i < exprs.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyString_FromString(exprs[i].c_str()));
    return retval;
}



PyMethodDef PyDeferExpressionAttributes_methods[DEFEREXPRESSIONATTRIBUTES_NMETH] = {
    {"Notify", DeferExpressionAttributes_Notify, METH_VARARGS},
    {"SetExprs", DeferExpressionAttributes_SetExprs, METH_VARARGS},
    {"GetExprs", DeferExpressionAttributes_GetExprs, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
DeferExpressionAttributes_dealloc(PyObject *v)
{
   DeferExpressionAttributesObject *obj = (DeferExpressionAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
DeferExpressionAttributes_compare(PyObject *v, PyObject *w)
{
    DeferExpressionAttributes *a = ((DeferExpressionAttributesObject *)v)->data;
    DeferExpressionAttributes *b = ((DeferExpressionAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyDeferExpressionAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "exprs") == 0)
        return DeferExpressionAttributes_GetExprs(self, NULL);

    return Py_FindMethod(PyDeferExpressionAttributes_methods, self, name);
}

int
PyDeferExpressionAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "exprs") == 0)
        obj = DeferExpressionAttributes_SetExprs(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
DeferExpressionAttributes_print(PyObject *v, FILE *fp, int flags)
{
    DeferExpressionAttributesObject *obj = (DeferExpressionAttributesObject *)v;
    fprintf(fp, "%s", PyDeferExpressionAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
DeferExpressionAttributes_str(PyObject *v)
{
    DeferExpressionAttributesObject *obj = (DeferExpressionAttributesObject *)v;
    return PyString_FromString(PyDeferExpressionAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *DeferExpressionAttributes_Purpose = "Attributes for the DeferExpression operator";
#else
static char *DeferExpressionAttributes_Purpose = "Attributes for the DeferExpression operator";
#endif

//
// The type description structure
//
static PyTypeObject DeferExpressionAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "DeferExpressionAttributes",                    // tp_name
    sizeof(DeferExpressionAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)DeferExpressionAttributes_dealloc,  // tp_dealloc
    (printfunc)DeferExpressionAttributes_print,     // tp_print
    (getattrfunc)PyDeferExpressionAttributes_getattr, // tp_getattr
    (setattrfunc)PyDeferExpressionAttributes_setattr, // tp_setattr
    (cmpfunc)DeferExpressionAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)DeferExpressionAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    DeferExpressionAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static DeferExpressionAttributes *defaultAtts = 0;
static DeferExpressionAttributes *currentAtts = 0;

static PyObject *
NewDeferExpressionAttributes(int useCurrent)
{
    DeferExpressionAttributesObject *newObject;
    newObject = PyObject_NEW(DeferExpressionAttributesObject, &DeferExpressionAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new DeferExpressionAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new DeferExpressionAttributes(*defaultAtts);
    else
        newObject->data = new DeferExpressionAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapDeferExpressionAttributes(const DeferExpressionAttributes *attr)
{
    DeferExpressionAttributesObject *newObject;
    newObject = PyObject_NEW(DeferExpressionAttributesObject, &DeferExpressionAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (DeferExpressionAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
DeferExpressionAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewDeferExpressionAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef DeferExpressionAttributesMethods[] = {
    {"DeferExpressionAttributes", DeferExpressionAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *DeferExpressionAttributesObserver = 0;

std::string
PyDeferExpressionAttributes_GetLogString()
{
    std::string s("DeferExpressionAtts = DeferExpressionAttributes()\n");
    if(currentAtts != 0)
        s += PyDeferExpressionAttributes_ToString(currentAtts, "DeferExpressionAtts.");
    return s;
}

static void
PyDeferExpressionAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("DeferExpressionAtts = DeferExpressionAttributes()\n");
        s += PyDeferExpressionAttributes_ToString(currentAtts, "DeferExpressionAtts.");
        cb(s);
    }
}

void
PyDeferExpressionAttributes_StartUp(DeferExpressionAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyDeferExpressionAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(DeferExpressionAttributesObserver == 0)
    {
        DeferExpressionAttributesObserver = new ObserverToCallback(subj,
            PyDeferExpressionAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyDeferExpressionAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete DeferExpressionAttributesObserver;
    DeferExpressionAttributesObserver = 0;
}

PyMethodDef *
PyDeferExpressionAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return DeferExpressionAttributesMethods;
}

bool
PyDeferExpressionAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &DeferExpressionAttributesType);
}

DeferExpressionAttributes *
PyDeferExpressionAttributes_FromPyObject(PyObject *obj)
{
    DeferExpressionAttributesObject *obj2 = (DeferExpressionAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyDeferExpressionAttributes_New()
{
    return NewDeferExpressionAttributes(0);
}

PyObject *
PyDeferExpressionAttributes_Wrap(const DeferExpressionAttributes *attr)
{
    return WrapDeferExpressionAttributes(attr);
}

void
PyDeferExpressionAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    DeferExpressionAttributesObject *obj2 = (DeferExpressionAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyDeferExpressionAttributes_SetDefaults(const DeferExpressionAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new DeferExpressionAttributes(*atts);
}

