// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: DecimatePluginInfo.h
// ****************************************************************************

#ifndef DECIMATE_PLUGIN_INFO_H
#define DECIMATE_PLUGIN_INFO_H
#include <OperatorPluginInfo.h>
#include <operator_plugin_exports.h>

class DecimateAttributes;

// ****************************************************************************
//  Class: DecimatePluginInfo
//
//  Purpose:
//    Five classes that provide all the information about an Decimate operator
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
//  Modifications:
//
// ****************************************************************************

class DecimateGeneralPluginInfo : public virtual GeneralOperatorPluginInfo
{
  public:
    virtual const char *GetName() const;
    virtual const char *GetVersion() const;
    virtual const char *GetID() const;
    virtual bool  EnabledByDefault() const;
    virtual const char *GetCategoryName() const;
};

class DecimateCommonPluginInfo : public virtual CommonOperatorPluginInfo, public virtual DecimateGeneralPluginInfo
{
  public:
    virtual AttributeSubject *AllocAttributes();
    virtual void CopyAttributes(AttributeSubject *to, AttributeSubject *from);
};

class DecimateGUIPluginInfo : public virtual GUIOperatorPluginInfo, public virtual DecimateCommonPluginInfo
{
  public:
    virtual QString *GetMenuName() const;
    virtual QvisPostableWindowObserver *CreatePluginWindow(int type,
        AttributeSubject *attr, const QString &caption, const QString &shortName,
        QvisNotepadArea *notepad);
};

class DecimateViewerEnginePluginInfo : public virtual ViewerEngineOperatorPluginInfo, public virtual DecimateCommonPluginInfo
{
  public:
    virtual AttributeSubject *GetClientAtts();
    virtual AttributeSubject *GetDefaultAtts();
    virtual void SetClientAtts(AttributeSubject *atts);
    virtual void GetClientAtts(AttributeSubject *atts);

    virtual void InitializeOperatorAtts(AttributeSubject *atts,
                                        const avtPlotMetaData &plot,
                                        const bool fromDefault);
    virtual void UpdateOperatorAtts(AttributeSubject *atts,
                                    const avtPlotMetaData &plot);
    virtual const char *GetMenuName() const;

    static void InitializeGlobalObjects();
  private:
    static DecimateAttributes *defaultAtts;
    static DecimateAttributes *clientAtts;
};

class DecimateViewerPluginInfo : public virtual ViewerOperatorPluginInfo, public virtual DecimateViewerEnginePluginInfo
{
  public:
};

class DecimateEnginePluginInfo : public virtual EngineOperatorPluginInfo, public virtual DecimateViewerEnginePluginInfo
{
  public:
    virtual avtPluginFilter *AllocAvtPluginFilter();
};

class DecimateScriptingPluginInfo : public virtual ScriptingOperatorPluginInfo, public virtual DecimateCommonPluginInfo
{
  public:
    virtual void InitializePlugin(AttributeSubject *subj, void *data);
    virtual void *GetMethodTable(int *nMethods);
    virtual bool TypesMatch(void *pyobject);
    virtual char *GetLogString();
    virtual void SetDefaults(const AttributeSubject *atts);
};

#endif
