// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: DecimateCommonPluginInfo.C
// ****************************************************************************

#include <DecimatePluginInfo.h>
#include <DecimateAttributes.h>

// ****************************************************************************
//  Method: DecimateCommonPluginInfo::AllocAttributes
//
//  Purpose:
//    Return a pointer to a newly allocated attribute subject.
//
//  Returns:    A pointer to the newly allocated attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
DecimateCommonPluginInfo::AllocAttributes()
{
    return new DecimateAttributes;
}

// ****************************************************************************
//  Method: DecimateCommonPluginInfo::CopyAttributes
//
//  Purpose:
//    Copy a Decimate attribute subject.
//
//  Arguments:
//    to        The destination attribute subject.
//    from      The source attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
DecimateCommonPluginInfo::CopyAttributes(AttributeSubject *to,
    AttributeSubject *from)
{
    *((DecimateAttributes *) to) = *((DecimateAttributes *) from);
}
