// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

package llnl.visit.operators;

import llnl.visit.AttributeSubject;
import llnl.visit.CommunicationBuffer;
import llnl.visit.Plugin;

// ****************************************************************************
// Class: DecimateAttributes
//
// Purpose:
//    This class contains attributes for the decimate operator.
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

public class DecimateAttributes extends AttributeSubject implements Plugin
{
    private static int DecimateAttributes_numAdditionalAtts = 1;

    public DecimateAttributes()
    {
        super(DecimateAttributes_numAdditionalAtts);

        target = 0.1;
    }

    public DecimateAttributes(int nMoreFields)
    {
        super(DecimateAttributes_numAdditionalAtts + nMoreFields);

        target = 0.1;
    }

    public DecimateAttributes(DecimateAttributes obj)
    {
        super(obj);

        target = obj.target;

        SelectAll();
    }

    public int Offset()
    {
        return super.Offset() + super.GetNumAdditionalAttributes();
    }

    public int GetNumAdditionalAttributes()
    {
        return DecimateAttributes_numAdditionalAtts;
    }

    public boolean equals(DecimateAttributes obj)
    {
        // Create the return value
        return ((target == obj.target));
    }

    public String GetName() { return "Decimate"; }
    public String GetVersion() { return "1.0"; }

    // Property setting methods
    public void SetTarget(double target_)
    {
        target = target_;
        Select(0);
    }

    // Property getting methods
    public double GetTarget() { return target; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        if(WriteSelect(0, buf))
            buf.WriteDouble(target);
    }

    public void ReadAtts(int index, CommunicationBuffer buf)
    {
        SetTarget(buf.ReadDouble());
    }

    public String toString(String indent)
    {
        String str = new String();
        str = str + doubleToString("target", target, indent) + "\n";
        return str;
    }


    // Attributes
    private double target;
}

