// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  File: avtDataBinningFilter.h
// ************************************************************************* //

#ifndef AVT_DataBinning_FILTER_H
#define AVT_DataBinning_FILTER_H

#include <avtPluginDatasetToDatasetFilter.h>
#include <DataBinningAttributes.h>

class     avtDataBinning;


// ****************************************************************************
//  Class: avtDataBinningFilter
//
//  Purpose:
//      A plugin operator for DataBinning.
//
//  Programmer: hchilds -- generated by xml2avt
//  Creation:   Thu Aug 19 20:24:23 PST 2010
//
// ****************************************************************************

class avtDataBinningFilter : public avtPluginDatasetToDatasetFilter
{
  public:
                         avtDataBinningFilter();
    virtual             ~avtDataBinningFilter();

    static avtFilter    *Create();

    virtual const char  *GetType(void)  { return "avtDataBinningFilter"; };
    virtual const char  *GetDescription(void)
                             { return "DataBinning"; };

    virtual void         SetAtts(const AttributeGroup*);
    virtual bool         Equivalent(const AttributeGroup*);

  protected:
    DataBinningAttributes   atts;
    avtContract_p           lastContract;
    std::string             varname;

    virtual void          Execute(void);
    virtual void          UpdateDataObjectInfo(void);
    virtual avtContract_p ModifyContract(avtContract_p);
    void                  SetAxisNamesAndUnits(void);
    avtDataTree_p         CreateArrayFromDataBinning(avtDataTree_p, 
                                           avtDataBinning *, double *, bool &);
};


#endif


