// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef QVISBINWINDOW_H
#define QVISBINWINDOW_H

#include <QvisOperatorWindow.h>
#include <AttributeSubject.h>

class DataBinningAttributes;
class QLabel;
class QCheckBox;
class QComboBox;
class QLineEdit;
class QButtonGroup;
class QRadioButton;
class QvisVariableButton;

// ****************************************************************************
// Class: QvisDataBinningWindow
//
// Purpose:
//    Defines QvisDataBinningWindow class.
//
// Notes:      Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
//   Hank Childs, Sun Jul 31 16:01:41 PDT 2011
//   Add support for binning based on spatial dimensions.
//
//   Hank Childs, Fri Jan  4 11:49:36 PST 2013
//   Remove unused bins for curves.
//
// ****************************************************************************

class QvisDataBinningWindow : public QvisOperatorWindow
{
    Q_OBJECT
  public:
    QvisDataBinningWindow(const int type,
                         DataBinningAttributes *subj,
                         const QString &caption = QString::null,
                         const QString &shortName = QString::null,
                         QvisNotepadArea *notepad = 0);
    virtual ~QvisDataBinningWindow();
    virtual void CreateWindowContents();
  protected:
    void UpdateWindow(bool doAll);
    virtual void GetCurrentValues(int which_widget);
  private slots:
    void numDimensionsChanged(int val);
    void dim1VarChanged(const QString &varName);
    void dim1SpecifyRangeToggled(bool);
    void dim1MinRangeProcessText();
    void dim1MaxRangeProcessText();
    void dim1NumBinsProcessText();
    void dim1BinBasedOnChanged(int);
    void dim2VarChanged(const QString &varName);
    void dim2SpecifyRangeToggled(bool);
    void dim2MinRangeProcessText();
    void dim2MaxRangeProcessText();
    void dim2NumBinsProcessText();
    void dim2BinBasedOnChanged(int);
    void dim3VarChanged(const QString &varName);
    void dim3SpecifyRangeToggled(bool);
    void dim3MinRangeProcessText();
    void dim3MaxRangeProcessText();
    void dim3NumBinsProcessText();
    void dim3BinBasedOnChanged(int);
    void outOfBoundsBehaviorChanged(int val);
    void outputChanged(int val);
    void reductionOperatorClicked(int val);
    void varForReductionChanged(const QString &varName);
    void emptyValProcessText();
    void removeEmptyBinsToggled(bool);
  private:
    QWidget      *numDimensions;
    QComboBox    *numDimensionsCombo;
    QvisVariableButton *dim1Var;
    QCheckBox *dim1SpecifyRange;
    QLineEdit *dim1MinRange;
    QLineEdit *dim1MaxRange;
    QLineEdit *dim1NumBins;
    QvisVariableButton *dim2Var;
    QCheckBox *dim2SpecifyRange;
    QLineEdit *dim2MinRange;
    QLineEdit *dim2MaxRange;
    QLineEdit *dim2NumBins;
    QvisVariableButton *dim3Var;
    QCheckBox *dim3SpecifyRange;
    QLineEdit *dim3MinRange;
    QLineEdit *dim3MaxRange;
    QLineEdit *dim3NumBins;
    QWidget      *outOfBoundsBehavior;
    QButtonGroup *outOfBoundsBehaviorButtonGroup;
    QWidget      *reductionOperator;
    QComboBox    *reductionCombo;
    QvisVariableButton *varForReduction;
    QLineEdit *emptyVal;
    QLabel *numDimensionsLabel;
    QLabel *dim1BinBasedOn;
    QRadioButton *dim1VarLabel;
    QRadioButton *dim1XLabel;
    QRadioButton *dim1YLabel;
    QRadioButton *dim1ZLabel;
    QButtonGroup *dim1BinBasedOnButtonGroup;
    QLabel *dim1MinRangeLabel;
    QLabel *dim1MaxRangeLabel;
    QLabel *dim1NumBinsLabel;
    QLabel *dim2BinBasedOn;
    QRadioButton *dim2VarLabel;
    QRadioButton *dim2XLabel;
    QRadioButton *dim2YLabel;
    QRadioButton *dim2ZLabel;
    QButtonGroup *dim2BinBasedOnButtonGroup;
    QLabel *dim2MinRangeLabel;
    QLabel *dim2MaxRangeLabel;
    QLabel *dim2NumBinsLabel;
    QLabel *dim3BinBasedOn;
    QRadioButton *dim3VarLabel;
    QRadioButton *dim3XLabel;
    QRadioButton *dim3YLabel;
    QRadioButton *dim3ZLabel;
    QButtonGroup *dim3BinBasedOnButtonGroup;
    QLabel *dim3MinRangeLabel;
    QLabel *dim3MaxRangeLabel;
    QLabel *dim3NumBinsLabel;
    QLabel *outOfBoundsBehaviorLabel;
    QLabel *reductionOperatorLabel;
    QLabel *varForReductionLabel;
    QLabel *emptyValLabel;
    QCheckBox *removeEmptyBins;
    QButtonGroup *outputButtonGroup;

    DataBinningAttributes *atts;
};



#endif
