// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  DataBinningScriptingPluginInfo.C
// ************************************************************************* //
#include <PyDataBinningAttributes.h>
#include <DataBinningPluginInfo.h>

VISIT_OPERATOR_PLUGIN_ENTRY(DataBinning,Scripting)

// ****************************************************************************
// Method: DataBinningScriptingPluginInfo::InitializePlugin
//
// Purpose:
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   data    : A pointer to data to be used by the observer function.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
DataBinningScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    void *data)
{
    PyDataBinningAttributes_StartUp((DataBinningAttributes *)subj, data);
}

// ****************************************************************************
// Method: DataBinningScriptingPluginInfo::GetMethodTable
//
// Purpose:
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void *
DataBinningScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyDataBinningAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: DataBinningScriptingPluginInfo::TypesMatch
//
// Purpose:
//   Returns whether or not the input PyObject is DataBinning plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
DataBinningScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyDataBinningAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: DataBinningScriptingPluginInfo::GetLogString
//
// Purpose:
//   Gets a string representation of the current attributes.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

char *
DataBinningScriptingPluginInfo::GetLogString()
{
    std::string s(PyDataBinningAttributes_GetLogString());
    char *v = new char[s.size() + 1];
    strcpy(v, s.c_str());
    return v;
}

// ****************************************************************************
// Method: DataBinningScriptingPluginInfo::SetDefaults
//
// Purpose:
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
DataBinningScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyDataBinningAttributes_SetDefaults((const DataBinningAttributes *)atts);
}
