// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: DataBinningPluginInfo.h
// ****************************************************************************

#ifndef DATABINNING_PLUGIN_INFO_H
#define DATABINNING_PLUGIN_INFO_H
#include <OperatorPluginInfo.h>
#include <operator_plugin_exports.h>

class DataBinningAttributes;

// ****************************************************************************
//  Class: DataBinningPluginInfo
//
//  Purpose:
//    Five classes that provide all the information about an DataBinning operator
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
//  Modifications:
//
// ****************************************************************************

class DataBinningGeneralPluginInfo : public virtual GeneralOperatorPluginInfo
{
  public:
    virtual const char *GetName() const;
    virtual const char *GetVersion() const;
    virtual const char *GetID() const;
    virtual bool  EnabledByDefault() const;
    virtual const char *GetCategoryName() const;
};

class DataBinningCommonPluginInfo : public virtual CommonOperatorPluginInfo, public virtual DataBinningGeneralPluginInfo
{
  public:
    virtual AttributeSubject *AllocAttributes();
    virtual void CopyAttributes(AttributeSubject *to, AttributeSubject *from);
    virtual ExpressionList *GetCreatedExpressions(const avtDatabaseMetaData *) const;
};

class DataBinningGUIPluginInfo : public virtual GUIOperatorPluginInfo, public virtual DataBinningCommonPluginInfo
{
  public:
    virtual QString *GetMenuName() const;
    virtual QvisPostableWindowObserver *CreatePluginWindow(int type,
        AttributeSubject *attr, const QString &caption, const QString &shortName,
        QvisNotepadArea *notepad);
};

class DataBinningViewerEnginePluginInfo : public virtual ViewerEngineOperatorPluginInfo, public virtual DataBinningCommonPluginInfo
{
  public:
    virtual AttributeSubject *GetClientAtts();
    virtual AttributeSubject *GetDefaultAtts();
    virtual void SetClientAtts(AttributeSubject *atts);
    virtual void GetClientAtts(AttributeSubject *atts);

    virtual void InitializeOperatorAtts(AttributeSubject *atts,
                                        const avtPlotMetaData &plot,
                                        const bool fromDefault);
    virtual void UpdateOperatorAtts(AttributeSubject *atts,
                                    const avtPlotMetaData &plot);
    virtual const char *GetMenuName() const;

    static void InitializeGlobalObjects();
  private:
    static DataBinningAttributes *defaultAtts;
    static DataBinningAttributes *clientAtts;
};

class DataBinningViewerPluginInfo : public virtual ViewerOperatorPluginInfo, public virtual DataBinningViewerEnginePluginInfo
{
  public:
};

class DataBinningEnginePluginInfo : public virtual EngineOperatorPluginInfo, public virtual DataBinningViewerEnginePluginInfo
{
  public:
    virtual avtPluginFilter *AllocAvtPluginFilter();
};

class DataBinningScriptingPluginInfo : public virtual ScriptingOperatorPluginInfo, public virtual DataBinningCommonPluginInfo
{
  public:
    virtual void InitializePlugin(AttributeSubject *subj, void *data);
    virtual void *GetMethodTable(int *nMethods);
    virtual bool TypesMatch(void *pyobject);
    virtual char *GetLogString();
    virtual void SetDefaults(const AttributeSubject *atts);
};

#endif
