// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: DataBinningCommonPluginInfo.C
// ****************************************************************************

#include <DataBinningPluginInfo.h>
#include <DataBinningAttributes.h>

#include <Expression.h>
#include <ExpressionList.h>
#include <avtDatabaseMetaData.h>
#include <avtMeshMetaData.h>

// ****************************************************************************
//  Method: DataBinningCommonPluginInfo::AllocAttributes
//
//  Purpose:
//    Return a pointer to a newly allocated attribute subject.
//
//  Returns:    A pointer to the newly allocated attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
DataBinningCommonPluginInfo::AllocAttributes()
{
    return new DataBinningAttributes;
}

// ****************************************************************************
//  Method: DataBinningCommonPluginInfo::CopyAttributes
//
//  Purpose:
//    Copy a DataBinning attribute subject.
//
//  Arguments:
//    to        The destination attribute subject.
//    from      The source attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
DataBinningCommonPluginInfo::CopyAttributes(AttributeSubject *to,
    AttributeSubject *from)
{
    *((DataBinningAttributes *) to) = *((DataBinningAttributes *) from);
}

ExpressionList *
DataBinningCommonPluginInfo::GetCreatedExpressions(const avtDatabaseMetaData *md) const
{
    char name[1024];
    char defn[1024];
    ExpressionList *el = new ExpressionList;

    for (int i = 0 ; i < md->GetNumMeshes() ; i++)
    {
        const char *mesh = md->GetMeshes(i).name.c_str();

        if (md->GetMeshes(i).hideFromGUI || !md->GetMeshes(i).validVariable)
            continue;

        Expression e2;
        sprintf(name, "operators/DataBinning/1D/%s", mesh);
        e2.SetName(name);
        e2.SetType(Expression::CurveMeshVar);
        e2.SetFromOperator(true);
        e2.SetOperatorName("DataBinning");
        sprintf(defn, "cell_constant(<%s>, 0)", mesh);
        e2.SetDefinition(defn);
        el->AddExpressions(e2);

        Expression e;
        sprintf(name, "operators/DataBinning/2D/%s", mesh);
        e.SetName(name);
        e.SetType(Expression::ScalarMeshVar);
        e.SetFromOperator(true);
        e.SetOperatorName("DataBinning");
        sprintf(defn, "cell_constant(<%s>, 0)", mesh);
        e.SetDefinition(defn);
        el->AddExpressions(e);

        Expression e3;
        sprintf(name, "operators/DataBinning/3D/%s", mesh);
        e3.SetName(name);
        e3.SetType(Expression::ScalarMeshVar);
        e3.SetFromOperator(true);
        e3.SetOperatorName("DataBinning");
        sprintf(defn, "cell_constant(<%s>, 0)", mesh);
        e3.SetDefinition(defn);
        el->AddExpressions(e3);
    }

    return el;
}

