// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include "QvisCylinderWindow.h"

#include <CylinderAttributes.h>

#include <QCheckBox>
#include <QLabel>
#include <QLayout>
#include <QLineEdit>


// ****************************************************************************
// Method: QvisCylinderWindow::QvisCylinderWindow
//
// Purpose: 
//   Constructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisCylinderWindow::QvisCylinderWindow(const int type,
                         CylinderAttributes *subj,
                         const QString &caption,
                         const QString &shortName,
                         QvisNotepadArea *notepad)
    : QvisOperatorWindow(type,subj, caption, shortName, notepad)
{
    atts = subj;
}


// ****************************************************************************
// Method: QvisCylinderWindow::~QvisCylinderWindow
//
// Purpose: 
//   Destructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisCylinderWindow::~QvisCylinderWindow()
{
}


// ****************************************************************************
// Method: QvisCylinderWindow::CreateWindowContents
//
// Purpose: 
//   Creates the widgets for the window.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisCylinderWindow::CreateWindowContents()
{
    QGridLayout *mainLayout = new QGridLayout(0);
    topLayout->addLayout(mainLayout);

    point1Label = new QLabel(tr("Endpoint 1"), central);
    mainLayout->addWidget(point1Label,0,0);
    point1 = new QLineEdit(central);
    connect(point1, SIGNAL(returnPressed()),
            this, SLOT(point1ProcessText()));
    mainLayout->addWidget(point1, 0,1);

    point2Label = new QLabel(tr("Endpoint 2"), central);
    mainLayout->addWidget(point2Label,1,0);
    point2 = new QLineEdit(central);
    connect(point2, SIGNAL(returnPressed()),
            this, SLOT(point2ProcessText()));
    mainLayout->addWidget(point2, 1,1);

    radiusLabel = new QLabel(tr("Radius"), central);
    mainLayout->addWidget(radiusLabel,2,0);
    radius = new QLineEdit(central);
    connect(radius, SIGNAL(returnPressed()),
            this, SLOT(radiusProcessText()));
    mainLayout->addWidget(radius, 2,1);

    inverse = new QCheckBox(tr("Inverse"), central);
    connect(inverse, SIGNAL(toggled(bool)),
            this, SLOT(inverseChanged(bool)));
    mainLayout->addWidget(inverse, 3,0);

}


// ****************************************************************************
// Method: QvisCylinderWindow::UpdateWindow
//
// Purpose: 
//   Updates the widgets in the window when the subject changes.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisCylinderWindow::UpdateWindow(bool doAll)
{

    for(int i = 0; i < atts->NumAttributes(); ++i)
    {
        if(!doAll)
        {
            if(!atts->IsSelected(i))
            {
                continue;
            }
        }

        switch(i)
        {
          case CylinderAttributes::ID_point1:
            point1->setText(DoublesToQString(atts->GetPoint1(), 3));
            break;
          case CylinderAttributes::ID_point2:
            point2->setText(DoublesToQString(atts->GetPoint2(), 3));
            break;
          case CylinderAttributes::ID_radius:
            radius->setText(DoubleToQString(atts->GetRadius()));
            break;
          case CylinderAttributes::ID_inverse:
            inverse->blockSignals(true);
            inverse->setChecked(atts->GetInverse());
            inverse->blockSignals(false);
            break;
        }
    }
}


// ****************************************************************************
// Method: QvisCylinderWindow::GetCurrentValues
//
// Purpose: 
//   Gets values from certain widgets and stores them in the subject.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisCylinderWindow::GetCurrentValues(int which_widget)
{
    bool doAll = (which_widget == -1);

    // Do point1
    if(which_widget == CylinderAttributes::ID_point1 || doAll)
    {
        double val[3];
        if(LineEditGetDoubles(point1, val, 3))
            atts->SetPoint1(val);
        else
        {
            ResettingError(tr("Endpoint 1"),
                DoublesToQString(atts->GetPoint1(),3));
            atts->SetPoint1(atts->GetPoint1());
        }
    }

    // Do point2
    if(which_widget == CylinderAttributes::ID_point2 || doAll)
    {
        double val[3];
        if(LineEditGetDoubles(point2, val, 3))
            atts->SetPoint2(val);
        else
        {
            ResettingError(tr("Endpoint 2"),
                DoublesToQString(atts->GetPoint2(),3));
            atts->SetPoint2(atts->GetPoint2());
        }
    }

    // Do radius
    if(which_widget == CylinderAttributes::ID_radius || doAll)
    {
        double val;
        if(LineEditGetDouble(radius, val))
            atts->SetRadius(val);
        else
        {
            ResettingError(tr("Radius"),
                DoubleToQString(atts->GetRadius()));
            atts->SetRadius(atts->GetRadius());
        }
    }

}


//
// Qt Slot functions
//


void
QvisCylinderWindow::point1ProcessText()
{
    GetCurrentValues(CylinderAttributes::ID_point1);
    Apply();
}


void
QvisCylinderWindow::point2ProcessText()
{
    GetCurrentValues(CylinderAttributes::ID_point2);
    Apply();
}


void
QvisCylinderWindow::radiusProcessText()
{
    GetCurrentValues(CylinderAttributes::ID_radius);
    Apply();
}


void
QvisCylinderWindow::inverseChanged(bool val)
{
    atts->SetInverse(val);
    SetUpdate(false);
    Apply();
}


