// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  CylinderScriptingPluginInfo.C
// ************************************************************************* //
#include <PyCylinderAttributes.h>
#include <CylinderPluginInfo.h>

VISIT_OPERATOR_PLUGIN_ENTRY(Cylinder,Scripting)

// ****************************************************************************
// Method: CylinderScriptingPluginInfo::InitializePlugin
//
// Purpose:
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   data    : A pointer to data to be used by the observer function.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
CylinderScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    void *data)
{
    PyCylinderAttributes_StartUp((CylinderAttributes *)subj, data);
}

// ****************************************************************************
// Method: CylinderScriptingPluginInfo::GetMethodTable
//
// Purpose:
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void *
CylinderScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyCylinderAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: CylinderScriptingPluginInfo::TypesMatch
//
// Purpose:
//   Returns whether or not the input PyObject is Cylinder plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
CylinderScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyCylinderAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: CylinderScriptingPluginInfo::GetLogString
//
// Purpose:
//   Gets a string representation of the current attributes.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

char *
CylinderScriptingPluginInfo::GetLogString()
{
    std::string s(PyCylinderAttributes_GetLogString());
    char *v = new char[s.size() + 1];
    strcpy(v, s.c_str());
    return v;
}

// ****************************************************************************
// Method: CylinderScriptingPluginInfo::SetDefaults
//
// Purpose:
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
CylinderScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyCylinderAttributes_SetDefaults((const CylinderAttributes *)atts);
}
