// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: CylinderCommonPluginInfo.C
// ****************************************************************************

#include <CylinderPluginInfo.h>
#include <CylinderAttributes.h>

// ****************************************************************************
//  Method: CylinderCommonPluginInfo::AllocAttributes
//
//  Purpose:
//    Return a pointer to a newly allocated attribute subject.
//
//  Returns:    A pointer to the newly allocated attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
CylinderCommonPluginInfo::AllocAttributes()
{
    return new CylinderAttributes;
}

// ****************************************************************************
//  Method: CylinderCommonPluginInfo::CopyAttributes
//
//  Purpose:
//    Copy a Cylinder attribute subject.
//
//  Arguments:
//    to        The destination attribute subject.
//    from      The source attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
CylinderCommonPluginInfo::CopyAttributes(AttributeSubject *to,
    AttributeSubject *from)
{
    *((CylinderAttributes *) to) = *((CylinderAttributes *) from);
}
