// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef CYLINDERATTRIBUTES_H
#define CYLINDERATTRIBUTES_H
#include <AttributeSubject.h>

#include <Line.h>

// ****************************************************************************
// Class: CylinderAttributes
//
// Purpose:
//    Contain the attributes for a cylinder
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class CylinderAttributes : public AttributeSubject
{
public:
    // These constructors are for objects of this class
    CylinderAttributes();
    CylinderAttributes(const CylinderAttributes &obj);
protected:
    // These constructors are for objects derived from this class
    CylinderAttributes(private_tmfs_t tmfs);
    CylinderAttributes(const CylinderAttributes &obj, private_tmfs_t tmfs);
public:
    virtual ~CylinderAttributes();

    virtual CylinderAttributes& operator = (const CylinderAttributes &obj);
    virtual bool operator == (const CylinderAttributes &obj) const;
    virtual bool operator != (const CylinderAttributes &obj) const;
private:
    void Init();
    void Copy(const CylinderAttributes &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectPoint1();
    void SelectPoint2();

    // Property setting methods
    void SetPoint1(const double *point1_);
    void SetPoint2(const double *point2_);
    void SetRadius(double radius_);
    void SetInverse(bool inverse_);

    // Property getting methods
    const double *GetPoint1() const;
          double *GetPoint1();
    const double *GetPoint2() const;
          double *GetPoint2();
    double       GetRadius() const;
    bool         GetInverse() const;

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);


    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;


    // IDs that can be used to identify fields in case statements
    enum {
        ID_point1 = 0,
        ID_point2,
        ID_radius,
        ID_inverse,
        ID__LAST
    };

private:
    double point1[3];
    double point2[3];
    double radius;
    bool   inverse;

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define CYLINDERATTRIBUTES_TMFS "DDdb"

#endif
