// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: CreateBondsPluginInfo.C
// ****************************************************************************

#include <CreateBondsPluginInfo.h>
#include <CreateBondsAttributes.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(CreateBonds,OP_EXPORT)

VISIT_OPERATOR_PLUGIN_ENTRY(CreateBonds,General)

// ****************************************************************************
//  Method: CreateBondsGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the operator plugin.
//
//  Returns:    A pointer to the name of the operator plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
CreateBondsGeneralPluginInfo::GetName() const
{
    return "CreateBonds";
}

// ****************************************************************************
//  Method: CreateBondsGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the operator plugin.
//
//  Returns:    A pointer to the version of the operator plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
CreateBondsGeneralPluginInfo::GetVersion() const
{
    return "1.0";
}

// ****************************************************************************
//  Method: CreateBondsGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the operator plugin.
//
//  Returns:    A pointer to the id of the operator plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
CreateBondsGeneralPluginInfo::GetID() const
{
    return "CreateBonds_1.0";
}
// ****************************************************************************
//  Method: CreateBondsGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
CreateBondsGeneralPluginInfo::EnabledByDefault() const
{
    return true;
}

// ****************************************************************************
//  Method: CreateBondsGeneralPluginInfo::GetCategoryName
//
//  Purpose:
//    Return the category name to which the operator belongs.
//
//  Returns:    Return the category name to which the operator belongs.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
CreateBondsGeneralPluginInfo::GetCategoryName() const
{
    return "Molecular";
}
