// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: CreateBondsGUIPluginInfo.C
// ****************************************************************************

#include <CreateBondsPluginInfo.h>
#include <CreateBondsAttributes.h>
#include <QApplication>
#include <QvisCreateBondsWindow.h>

VISIT_OPERATOR_PLUGIN_ENTRY(CreateBonds,GUI)

// ****************************************************************************
//  Method: CreateBondsGUIPluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the GUI menu.
//
//  Returns:    A pointer to the name to use in the GUI menu.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

QString *
CreateBondsGUIPluginInfo::GetMenuName() const
{
    return new QString(qApp->translate("OperatorNames", "CreateBonds"));
}


// ****************************************************************************
//  Method: CreateBondsGUIPluginInfo::CreatePluginWindow
//
//  Purpose:
//    Return a pointer to an operator's attribute window.
//
//  Arguments:
//    type      The type of the operator.
//    attr      The attribute subject for the operator.
//    notepad   The notepad to use for posting the window.
//
//  Returns:    A pointer to the operator's attribute window.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

QvisPostableWindowObserver *
CreateBondsGUIPluginInfo::CreatePluginWindow(int type, AttributeSubject *attr,
    const QString &caption, const QString &shortName, QvisNotepadArea *notepad)
{
    return new QvisCreateBondsWindow(type, (CreateBondsAttributes *)attr,
        caption, shortName, notepad);
}

// ****************************************************************************
//  Method: CreateBondsGUIPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

#include <CreateBonds.xpm>
const char **
CreateBondsGUIPluginInfo::XPMIconData() const
{
    return CreateBonds_xpm;
}

