// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: CreateBondsCommonPluginInfo.C
// ****************************************************************************

#include <CreateBondsPluginInfo.h>
#include <CreateBondsAttributes.h>

// ****************************************************************************
//  Method: CreateBondsCommonPluginInfo::AllocAttributes
//
//  Purpose:
//    Return a pointer to a newly allocated attribute subject.
//
//  Returns:    A pointer to the newly allocated attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
CreateBondsCommonPluginInfo::AllocAttributes()
{
    return new CreateBondsAttributes;
}

// ****************************************************************************
//  Method: CreateBondsCommonPluginInfo::CopyAttributes
//
//  Purpose:
//    Copy a CreateBonds attribute subject.
//
//  Arguments:
//    to        The destination attribute subject.
//    from      The source attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
CreateBondsCommonPluginInfo::CopyAttributes(AttributeSubject *to,
    AttributeSubject *from)
{
    *((CreateBondsAttributes *) to) = *((CreateBondsAttributes *) from);
}
