// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  CracksClipperScriptingPluginInfo.C
// ************************************************************************* //
#include <PyCracksClipperAttributes.h>
#include <CracksClipperPluginInfo.h>

VISIT_OPERATOR_PLUGIN_ENTRY(CracksClipper,Scripting)

// ****************************************************************************
// Method: CracksClipperScriptingPluginInfo::InitializePlugin
//
// Purpose:
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   data    : A pointer to data to be used by the observer function.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
CracksClipperScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    void *data)
{
    PyCracksClipperAttributes_StartUp((CracksClipperAttributes *)subj, data);
}

// ****************************************************************************
// Method: CracksClipperScriptingPluginInfo::GetMethodTable
//
// Purpose:
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void *
CracksClipperScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyCracksClipperAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: CracksClipperScriptingPluginInfo::TypesMatch
//
// Purpose:
//   Returns whether or not the input PyObject is CracksClipper plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
CracksClipperScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyCracksClipperAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: CracksClipperScriptingPluginInfo::GetLogString
//
// Purpose:
//   Gets a string representation of the current attributes.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

char *
CracksClipperScriptingPluginInfo::GetLogString()
{
    std::string s(PyCracksClipperAttributes_GetLogString());
    char *v = new char[s.size() + 1];
    strcpy(v, s.c_str());
    return v;
}

// ****************************************************************************
// Method: CracksClipperScriptingPluginInfo::SetDefaults
//
// Purpose:
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
CracksClipperScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyCracksClipperAttributes_SetDefaults((const CracksClipperAttributes *)atts);
}
