// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef QVISCOORDSWAPWINDOW_H
#define QVISCOORDSWAPWINDOW_H

#include <QvisOperatorWindow.h>
#include <AttributeSubject.h>

class CoordSwapAttributes;
class QLabel;
class QButtonGroup;

// ****************************************************************************
// Class: QvisCoordSwapWindow
//
// Purpose:
//    Defines QvisCoordSwapWindow class.
//
// Notes:      Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

class QvisCoordSwapWindow : public QvisOperatorWindow
{
    Q_OBJECT
  public:
    QvisCoordSwapWindow(const int type,
                         CoordSwapAttributes *subj,
                         const QString &caption = QString::null,
                         const QString &shortName = QString::null,
                         QvisNotepadArea *notepad = 0);
    virtual ~QvisCoordSwapWindow();
    virtual void CreateWindowContents();
  protected:
    void UpdateWindow(bool doAll);
    virtual void GetCurrentValues(int which_widget);
  private slots:
    void newCoord1Changed(int val);
    void newCoord2Changed(int val);
    void newCoord3Changed(int val);
  private:
    QWidget      *newCoord1;
    QButtonGroup *newCoord1ButtonGroup;
    QWidget      *newCoord2;
    QButtonGroup *newCoord2ButtonGroup;
    QWidget      *newCoord3;
    QButtonGroup *newCoord3ButtonGroup;
    QLabel *newCoord1Label;
    QLabel *newCoord2Label;
    QLabel *newCoord3Label;

    CoordSwapAttributes *atts;
};



#endif
