// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: CoordSwapCommonPluginInfo.C
// ****************************************************************************

#include <CoordSwapPluginInfo.h>
#include <CoordSwapAttributes.h>

// ****************************************************************************
//  Method: CoordSwapCommonPluginInfo::AllocAttributes
//
//  Purpose:
//    Return a pointer to a newly allocated attribute subject.
//
//  Returns:    A pointer to the newly allocated attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
CoordSwapCommonPluginInfo::AllocAttributes()
{
    return new CoordSwapAttributes;
}

// ****************************************************************************
//  Method: CoordSwapCommonPluginInfo::CopyAttributes
//
//  Purpose:
//    Copy a CoordSwap attribute subject.
//
//  Arguments:
//    to        The destination attribute subject.
//    from      The source attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
CoordSwapCommonPluginInfo::CopyAttributes(AttributeSubject *to,
    AttributeSubject *from)
{
    *((CoordSwapAttributes *) to) = *((CoordSwapAttributes *) from);
}
