// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  File: avtContextFilter.h
// ************************************************************************* //

#ifndef AVT_Context_FILTER_H
#define AVT_Context_FILTER_H

#include <avtPluginDataTreeIterator.h>

#include <ContextAttributes.h>


// ****************************************************************************
//  Class: avtContextFilter
//
//  Purpose:
//      A plugin operator for Context.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Fri Dec 21 14:23:41 PST 2001
//
//  Modifications:
//    Eric Brugger, Wed Jul 23 08:45:43 PDT 2014
//    Modified the class to work with avtDataRepresentation.
//
// ****************************************************************************

class avtContextFilter : public avtPluginDataTreeIterator
{
  public:
                         avtContextFilter();
    virtual             ~avtContextFilter();

    static avtFilter    *Create();

    virtual const char  *GetType(void)  { return "avtContextFilter"; };
    virtual const char  *GetDescription(void)
                             { return "Context"; };

    virtual void         SetAtts(const AttributeGroup*);
    virtual bool         Equivalent(const AttributeGroup*);

  protected:
    ContextAttributes     atts;

    virtual avtDataRepresentation *ExecuteData(avtDataRepresentation *);
    virtual avtContract_p
                          ModifyContract(avtContract_p);
    virtual void          UpdateDataObjectInfo(void);
};


#endif
