// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  File: avtContextFilter.C
// ************************************************************************* //

#include <avtContextFilter.h>

#include <vtkCellData.h>
#include <vtkDataSet.h>
#include <vtkDataArray.h>
#include <vtkPointData.h>

#include <NoInputException.h>


// ****************************************************************************
//  Method: avtContextFilter constructor
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Fri Dec 21 14:23:41 PST 2001
//
// ****************************************************************************

avtContextFilter::avtContextFilter()
{
}


// ****************************************************************************
//  Method: avtContextFilter destructor
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Fri Dec 21 14:23:41 PST 2001
//
//  Modifications:
//
// ****************************************************************************

avtContextFilter::~avtContextFilter()
{
}


// ****************************************************************************
//  Method:  avtContextFilter::Create
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Fri Dec 21 14:23:41 PST 2001
//
// ****************************************************************************

avtFilter *
avtContextFilter::Create()
{
    return new avtContextFilter();
}


// ****************************************************************************
//  Method:      avtContextFilter::SetAtts
//
//  Purpose:
//      Sets the state of the filter based on the attribute object.
//
//  Arguments:
//      a        The attributes to use.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Fri Dec 21 14:23:41 PST 2001
//
// ****************************************************************************

void
avtContextFilter::SetAtts(const AttributeGroup *a)
{
    atts = *(const ContextAttributes*)a;
}


// ****************************************************************************
//  Method: avtContextFilter::Equivalent
//
//  Purpose:
//      Returns true if creating a new avtContextFilter with the given
//      parameters would result in an equivalent avtContextFilter.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Fri Dec 21 14:23:41 PST 2001
//
// ****************************************************************************

bool
avtContextFilter::Equivalent(const AttributeGroup *a)
{
    return (atts == *(ContextAttributes*)a);
}


// ****************************************************************************
//  Method: avtContextFilter::ExecuteData
//
//  Purpose:
//      Sends the specified input and output through the Context filter.
//
//  Arguments:
//      in_dr      The input data representation.
//
//  Returns:       The output data representation.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Fri Dec 21 14:23:41 PST 2001
//
//  Modifications:
//    Kathleen Bonnell, Fri Feb  8 11:03:49 PST 2002
//    vtkScalars has been deprecated in VTK 4.0, use vtkDataArray 
//    and vtkFloatArray instead.
//
//    Kathleen Bonnell, Fri Dec 13 16:41:12 PST 2002   
//    Use NewInstance instead of MakeObject in order to match vtk's new api. 
//
//    Kathleen Biagas, Fri Sep 7 12:36:42 MST 2012
//    Preserve variable data type.
//
//    Eric Brugger, Wed Jul 23 08:46:04 PDT 2014
//    Modified the class to work with avtDataRepresentation.
//
// ****************************************************************************

avtDataRepresentation *
avtContextFilter::ExecuteData(avtDataRepresentation *in_dr)
{
    //
    // Get the VTK data set.
    //
    vtkDataSet *in_ds = in_dr->GetDataVTK();

    bool pointvar = false;
    vtkDataArray *primaryVar = in_ds->GetPointData()->GetScalars();
    if (primaryVar == NULL)
    {
        primaryVar = in_ds->GetCellData()->GetScalars();
    }
    else
    {
        pointvar = true;
    }

    if (primaryVar == NULL)
    {
        EXCEPTION0(NoInputException);
    }

    const char *contextVarName = atts.GetContext().c_str();
    vtkDataArray *contextVar = in_ds->GetPointData()->GetArray(contextVarName);
    bool contextPointVar = false;
    if (contextVar == NULL)
    {
        contextVar = in_ds->GetCellData()->GetArray(contextVarName);
    }
    else
    {
        contextPointVar = true;
    } 

    if (contextVar == NULL)
    {
        EXCEPTION0(NoInputException);
    }

    if (pointvar != contextPointVar)
    {
        cerr << "Currently unhandled case" << endl;
        return NULL;
    }

    int numVals;
    if (pointvar)
    {
        numVals = in_ds->GetNumberOfPoints();
    }
    else
    {
        numVals = in_ds->GetNumberOfCells();
    }

    vtkDataArray *outVar = primaryVar->NewInstance();
    outVar->SetNumberOfTuples(numVals);
    outVar->SetName(primaryVar->GetName());
    for (int i = 0 ; i < numVals ; i++)
    {
        double val = primaryVar->GetTuple1(i);
        if (val >= atts.GetLow() && val <= atts.GetHi())
        {
            outVar->SetTuple1(i, val + atts.GetOffset());
        }
        else
        {
            double cVal = contextVar->GetTuple1(i);
            if (cVal < atts.GetCutoff())
            {
                outVar->SetTuple1(i, atts.GetBelow());
            }
            else
            {
                outVar->SetTuple1(i, atts.GetAbove());
            }
        }
    }

    vtkDataSet *out_ds = (vtkDataSet *) in_ds->NewInstance();
    out_ds->ShallowCopy(in_ds);
    if (pointvar)
    {
        out_ds->GetPointData()->SetScalars(outVar);
    }
    else
    {
        out_ds->GetCellData()->SetScalars(outVar);
    }

    outVar->Delete();

    avtDataRepresentation *out_dr = new avtDataRepresentation(out_ds,
        in_dr->GetDomain(), in_dr->GetLabel());

    out_ds->Delete();

    return out_dr;
}


// ****************************************************************************
//  Method: avtContextFilter::ModifyContract
//
//  Purpose:
//      Adds the secondary variable we are interested in to the pipeline.
//
//  Programmer: Hank Childs
//  Creation:   December 21, 2001
//
// **************************************************************************** 

avtContract_p
avtContextFilter::ModifyContract(avtContract_p spec)
{
    avtDataRequest_p ds = spec->GetDataRequest();
    ds->AddSecondaryVariable(atts.GetContext().c_str());
    return spec;
}

// ****************************************************************************
// Method: avtContextFilter::UpdateDataObjectInfo
//
// Purpose:
//   Update the data object information.
//
// Note:       Work partially supported by DOE Grant SC0007548.
//
// Programmer: Brad Whitlock
// Creation:   Tue Mar 18 10:53:05 PDT 2014
//
// Modifications:
//
// ****************************************************************************

void
avtContextFilter::UpdateDataObjectInfo(void)
{
    avtPluginDataTreeIterator::UpdateDataObjectInfo();

    GetOutput()->GetInfo().GetAttributes().AddFilterMetaData("Context");
}
