// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  ContextScriptingPluginInfo.C
// ************************************************************************* //
#include <PyContextAttributes.h>
#include <ContextPluginInfo.h>

VISIT_OPERATOR_PLUGIN_ENTRY(Context,Scripting)

// ****************************************************************************
// Method: ContextScriptingPluginInfo::InitializePlugin
//
// Purpose:
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   data    : A pointer to data to be used by the observer function.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
ContextScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    void *data)
{
    PyContextAttributes_StartUp((ContextAttributes *)subj, data);
}

// ****************************************************************************
// Method: ContextScriptingPluginInfo::GetMethodTable
//
// Purpose:
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void *
ContextScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyContextAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: ContextScriptingPluginInfo::TypesMatch
//
// Purpose:
//   Returns whether or not the input PyObject is Context plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
ContextScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyContextAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: ContextScriptingPluginInfo::GetLogString
//
// Purpose:
//   Gets a string representation of the current attributes.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

char *
ContextScriptingPluginInfo::GetLogString()
{
    std::string s(PyContextAttributes_GetLogString());
    char *v = new char[s.size() + 1];
    strcpy(v, s.c_str());
    return v;
}

// ****************************************************************************
// Method: ContextScriptingPluginInfo::SetDefaults
//
// Purpose:
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
ContextScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyContextAttributes_SetDefaults((const ContextAttributes *)atts);
}
