// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: ContextCommonPluginInfo.C
// ****************************************************************************

#include <ContextPluginInfo.h>
#include <ContextAttributes.h>

// ****************************************************************************
//  Method: ContextCommonPluginInfo::AllocAttributes
//
//  Purpose:
//    Return a pointer to a newly allocated attribute subject.
//
//  Returns:    A pointer to the newly allocated attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
ContextCommonPluginInfo::AllocAttributes()
{
    return new ContextAttributes;
}

// ****************************************************************************
//  Method: ContextCommonPluginInfo::CopyAttributes
//
//  Purpose:
//    Copy a Context attribute subject.
//
//  Arguments:
//    to        The destination attribute subject.
//    from      The source attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
ContextCommonPluginInfo::CopyAttributes(AttributeSubject *to,
    AttributeSubject *from)
{
    *((ContextAttributes *) to) = *((ContextAttributes *) from);
}
