// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  File: avtConnectedComponentsFilter.h
// ************************************************************************* //

#ifndef AVT_ConnectedComponents_FILTER_H
#define AVT_ConnectedComponents_FILTER_H


#include <avtPluginFilter.h>
#include <avtDeferExpressionBaseFilter.h>
#include <ConnectedComponentsAttributes.h>


class vtkDataSet;


// ****************************************************************************
//  Class: avtConnectedComponentsFilter
//
//  Purpose:
//      A plugin operator for ConnectedComponents.
//
//  Programmer: hchilds -- generated by xml2avt
//  Creation:   Thu Sep 23 14:25:44 PST 2010
//
// ****************************************************************************

class avtConnectedComponentsFilter : virtual public avtPluginFilter,
                               virtual public avtDeferExpressionBaseFilter
{
  public:
                         avtConnectedComponentsFilter();
    virtual             ~avtConnectedComponentsFilter();

    static avtFilter    *Create();

    virtual const char  *GetType(void)  { return "avtConnectedComponentsFilter"; };
    virtual const char  *GetDescription(void)
                             { return "ConnectedComponents"; };

    virtual void         SetAtts(const AttributeGroup*);
    virtual bool         Equivalent(const AttributeGroup*);

  protected:
    ConnectedComponentsAttributes            atts;
    std::string               varname;

    virtual void              InferVariableNameFromContract(avtContract_p);
    virtual void              GetCustomExpressions(std::vector<Expression> &);
    virtual void              GetVariablesToEvaluate(std::vector<std::string> &);
};


#endif


