// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef QVISCONNECTEDCOMPONENTSWINDOW_H
#define QVISCONNECTEDCOMPONENTSWINDOW_H

#include <QvisOperatorWindow.h>
#include <AttributeSubject.h>

class ConnectedComponentsAttributes;
class QCheckBox;

// ****************************************************************************
// Class: QvisConnectedComponentsWindow
//
// Purpose:
//    Defines QvisConnectedComponentsWindow class.
//
// Notes:      Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

class QvisConnectedComponentsWindow : public QvisOperatorWindow
{
    Q_OBJECT
  public:
    QvisConnectedComponentsWindow(const int type,
                         ConnectedComponentsAttributes *subj,
                         const QString &caption = QString::null,
                         const QString &shortName = QString::null,
                         QvisNotepadArea *notepad = 0);
    virtual ~QvisConnectedComponentsWindow();
    virtual void CreateWindowContents();
  protected:
    void UpdateWindow(bool doAll);
    virtual void GetCurrentValues(int which_widget);
  private slots:
    void EnableGhostNeighborsOptimizationChanged(bool val);
  private:
    QCheckBox *EnableGhostNeighborsOptimization;

    ConnectedComponentsAttributes *atts;
};



#endif
