// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  ConnectedComponentsScriptingPluginInfo.C
// ************************************************************************* //
#include <PyConnectedComponentsAttributes.h>
#include <ConnectedComponentsPluginInfo.h>

VISIT_OPERATOR_PLUGIN_ENTRY(ConnectedComponents,Scripting)

// ****************************************************************************
// Method: ConnectedComponentsScriptingPluginInfo::InitializePlugin
//
// Purpose:
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   data    : A pointer to data to be used by the observer function.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
ConnectedComponentsScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    void *data)
{
    PyConnectedComponentsAttributes_StartUp((ConnectedComponentsAttributes *)subj, data);
}

// ****************************************************************************
// Method: ConnectedComponentsScriptingPluginInfo::GetMethodTable
//
// Purpose:
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void *
ConnectedComponentsScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyConnectedComponentsAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: ConnectedComponentsScriptingPluginInfo::TypesMatch
//
// Purpose:
//   Returns whether or not the input PyObject is ConnectedComponents plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
ConnectedComponentsScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyConnectedComponentsAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: ConnectedComponentsScriptingPluginInfo::GetLogString
//
// Purpose:
//   Gets a string representation of the current attributes.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

char *
ConnectedComponentsScriptingPluginInfo::GetLogString()
{
    std::string s(PyConnectedComponentsAttributes_GetLogString());
    char *v = new char[s.size() + 1];
    strcpy(v, s.c_str());
    return v;
}

// ****************************************************************************
// Method: ConnectedComponentsScriptingPluginInfo::SetDefaults
//
// Purpose:
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
ConnectedComponentsScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyConnectedComponentsAttributes_SetDefaults((const ConnectedComponentsAttributes *)atts);
}
