// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: ConnectedComponentsPluginInfo.h
// ****************************************************************************

#ifndef CONNECTEDCOMPONENTS_PLUGIN_INFO_H
#define CONNECTEDCOMPONENTS_PLUGIN_INFO_H
#include <OperatorPluginInfo.h>
#include <operator_plugin_exports.h>

class ConnectedComponentsAttributes;

// ****************************************************************************
//  Class: ConnectedComponentsPluginInfo
//
//  Purpose:
//    Five classes that provide all the information about an ConnectedComponents operator
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
//  Modifications:
//
// ****************************************************************************

class ConnectedComponentsGeneralPluginInfo : public virtual GeneralOperatorPluginInfo
{
  public:
    virtual const char *GetName() const;
    virtual const char *GetVersion() const;
    virtual const char *GetID() const;
    virtual bool  EnabledByDefault() const;
    virtual const char *GetCategoryName() const;
};

class ConnectedComponentsCommonPluginInfo : public virtual CommonOperatorPluginInfo, public virtual ConnectedComponentsGeneralPluginInfo
{
  public:
    virtual AttributeSubject *AllocAttributes();
    virtual void CopyAttributes(AttributeSubject *to, AttributeSubject *from);
    virtual ExpressionList *GetCreatedExpressions(const avtDatabaseMetaData *) const;
};

class ConnectedComponentsGUIPluginInfo : public virtual GUIOperatorPluginInfo, public virtual ConnectedComponentsCommonPluginInfo
{
  public:
    virtual QString *GetMenuName() const;
    virtual QvisPostableWindowObserver *CreatePluginWindow(int type,
        AttributeSubject *attr, const QString &caption, const QString &shortName,
        QvisNotepadArea *notepad);
};

class ConnectedComponentsViewerEnginePluginInfo : public virtual ViewerEngineOperatorPluginInfo, public virtual ConnectedComponentsCommonPluginInfo
{
  public:
    virtual AttributeSubject *GetClientAtts();
    virtual AttributeSubject *GetDefaultAtts();
    virtual void SetClientAtts(AttributeSubject *atts);
    virtual void GetClientAtts(AttributeSubject *atts);

    virtual void InitializeOperatorAtts(AttributeSubject *atts,
                                        const avtPlotMetaData &plot,
                                        const bool fromDefault);
    virtual void UpdateOperatorAtts(AttributeSubject *atts,
                                    const avtPlotMetaData &plot);
    virtual const char *GetMenuName() const;

    static void InitializeGlobalObjects();
  private:
    static ConnectedComponentsAttributes *defaultAtts;
    static ConnectedComponentsAttributes *clientAtts;
};

class ConnectedComponentsViewerPluginInfo : public virtual ViewerOperatorPluginInfo, public virtual ConnectedComponentsViewerEnginePluginInfo
{
  public:
};

class ConnectedComponentsEnginePluginInfo : public virtual EngineOperatorPluginInfo, public virtual ConnectedComponentsViewerEnginePluginInfo
{
  public:
    virtual avtPluginFilter *AllocAvtPluginFilter();
};

class ConnectedComponentsScriptingPluginInfo : public virtual ScriptingOperatorPluginInfo, public virtual ConnectedComponentsCommonPluginInfo
{
  public:
    virtual void InitializePlugin(AttributeSubject *subj, void *data);
    virtual void *GetMethodTable(int *nMethods);
    virtual bool TypesMatch(void *pyobject);
    virtual char *GetLogString();
    virtual void SetDefaults(const AttributeSubject *atts);
};

#endif
