// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: ConnectedComponentsPluginInfo.C
// ****************************************************************************

#include <ConnectedComponentsPluginInfo.h>
#include <ConnectedComponentsAttributes.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(ConnectedComponents,OP_EXPORT)

VISIT_OPERATOR_PLUGIN_ENTRY(ConnectedComponents,General)

// ****************************************************************************
//  Method: ConnectedComponentsGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the operator plugin.
//
//  Returns:    A pointer to the name of the operator plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
ConnectedComponentsGeneralPluginInfo::GetName() const
{
    return "ConnectedComponents";
}

// ****************************************************************************
//  Method: ConnectedComponentsGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the operator plugin.
//
//  Returns:    A pointer to the version of the operator plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
ConnectedComponentsGeneralPluginInfo::GetVersion() const
{
    return "1.0";
}

// ****************************************************************************
//  Method: ConnectedComponentsGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the operator plugin.
//
//  Returns:    A pointer to the id of the operator plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
ConnectedComponentsGeneralPluginInfo::GetID() const
{
    return "ConnectedComponents_1.0";
}
// ****************************************************************************
//  Method: ConnectedComponentsGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
ConnectedComponentsGeneralPluginInfo::EnabledByDefault() const
{
    return true;
}

// ****************************************************************************
//  Method: ConnectedComponentsGeneralPluginInfo::GetCategoryName
//
//  Purpose:
//    Return the category name to which the operator belongs.
//
//  Returns:    Return the category name to which the operator belongs.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
ConnectedComponentsGeneralPluginInfo::GetCategoryName() const
{
    return "Analysis";
}
